<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Users Controller
*| --------------------------------------------------------------------------
*| Users site
*|
*/
class Users extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_users');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Userss
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('users_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['userss'] = $this->model_users->get($filter, $field, $this->limit_page, $offset);
		$this->data['users_counts'] = $this->model_users->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/users/index/',
			'total_rows'   => $this->data['users_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Users List');
		$this->render('backend/standart/administrator/users/users_list', $this->data);
	}
	
	/**
	* Add new userss
	*
	*/
	public function add()
	{
		$this->is_allowed('users_add');

		$this->template->title('Users New');
		$this->render('backend/standart/administrator/users/users_add', $this->data);
	}

	/**
	* Add New Userss
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('users_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('employee_id', 'Employee Id', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('user_name', 'User Name', 'trim|max_length[255]|required');
		

		$this->form_validation->set_rules('password', 'Password', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('fullname', 'Fullname', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('address1', 'Address1', 'trim|max_length[255]');
		

		

		$this->form_validation->set_rules('city', 'City', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('pincode', 'Pincode', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('state', 'State', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('mobile', 'Mobile', 'trim|max_length[255]');
		

		

		

		$this->form_validation->set_rules('email', 'Email', 'trim|max_length[255]');
		

		

		

		

		if ($this->form_validation->run()) {
			$users_pp_uuid = $this->input->post('users_pp_uuid');
			$users_pp_name = $this->input->post('users_pp_name');
		
			$save_data = [
				'employee_id' => $this->input->post('employee_id'),
				'user_name' => $this->input->post('user_name'),
				'password' => password_hash($this->input->post('password'),PASSWORD_DEFAULT),
				'fullname' => $this->input->post('fullname'),
				'address1' => $this->input->post('address1'),
				'city' => $this->input->post('city'),
				'pincode' => $this->input->post('pincode'),
				'state' => $this->input->post('state'),
				'country' => $this->input->post('country'),
				'mobile' => $this->input->post('mobile'),
				'email' => $this->input->post('email'),
			];

			
			if (!is_dir(FCPATH . '/uploads/users/')) {
				mkdir(FCPATH . '/uploads/users/');
			}

			if (!empty($users_pp_name)) {
				$users_pp_name_copy = date('YmdHis') . '-' . $users_pp_name;

				rename(FCPATH . 'uploads/tmp/' . $users_pp_uuid . '/' . $users_pp_name, 
						FCPATH . 'uploads/users/' . $users_pp_name_copy);

				if (!is_file(FCPATH . '/uploads/users/' . $users_pp_name_copy)) {
					echo json_encode([
						'success' => false,
						'message' => 'Error uploading file'
						]);
					exit;
				}

				$save_data['pp'] = $users_pp_name_copy;
			}
		
			
			$save_users = $this->model_users->store($save_data);
            

			if ($save_users) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_users;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/users/edit/' . $save_users, 'Edit Users'),
						anchor('administrator/users', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/users/edit/' . $save_users, 'Edit Users')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/users');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/users');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Userss
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('users_update');

		$this->data['users'] = $this->model_users->find($id);

		$this->template->title('Users Update');
		$this->render('backend/standart/administrator/users/users_update', $this->data);
	}

	/**
	* Update Userss
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('users_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('employee_id', 'Employee Id', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('user_name', 'User Name', 'trim|max_length[255]|required');
		

		$this->form_validation->set_rules('password', 'Password', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('fullname', 'Fullname', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('address1', 'Address1', 'trim|max_length[255]');
		

		

		$this->form_validation->set_rules('city', 'City', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('pincode', 'Pincode', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('state', 'State', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('mobile', 'Mobile', 'trim|max_length[255]');
		

		

		

		$this->form_validation->set_rules('email', 'Email', 'trim|max_length[255]');
		

		$this->form_validation->set_rules('sex', 'Sex', 'trim|max_length[20]');
		

		

		
		if ($this->form_validation->run()) {
			$users_pp_uuid = $this->input->post('users_pp_uuid');
			$users_pp_name = $this->input->post('users_pp_name');
		
			$save_data = [
				'employee_id' => $this->input->post('employee_id'),
				'user_name' => $this->input->post('user_name'),
				'password' => $this->input->post('password'),
				'fullname' => $this->input->post('fullname'),
				'address1' => $this->input->post('address1'),
				'city' => $this->input->post('city'),
				'pincode' => $this->input->post('pincode'),
				'state' => $this->input->post('state'),
				'country' => $this->input->post('country'),
				'mobile' => $this->input->post('mobile'),
				'email' => $this->input->post('email'),
				'dob' => $this->input->post('dob'),
				'sex' => $this->input->post('sex'),
				'joined_date' => $this->input->post('joined_date'),
			];


			
			if (!is_dir(FCPATH . '/uploads/users/')) {
				mkdir(FCPATH . '/uploads/users/');
			}

			if (!empty($users_pp_uuid)) {
				$users_pp_name_copy = date('YmdHis') . '-' . $users_pp_name;

				rename(FCPATH . 'uploads/tmp/' . $users_pp_uuid . '/' . $users_pp_name, 
						FCPATH . 'uploads/users/' . $users_pp_name_copy);

				if (!is_file(FCPATH . '/uploads/users/' . $users_pp_name_copy)) {
					echo json_encode([
						'success' => false,
						'message' => 'Error uploading file'
						]);
					exit;
				}

				$save_data['pp'] = $users_pp_name_copy;
			}
		
			
			$save_users = $this->model_users->change($id, $save_data);

			if ($save_users) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/users', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/users');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/users');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Userss
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('users_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'users'), 'success');
        } else {
            set_message(cclang('error_delete', 'users'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Userss
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('users_view');

		$this->data['users'] = $this->model_users->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Users Detail');
		$this->render('backend/standart/administrator/users/users_view', $this->data);
	}
	
	/**
	* delete Userss
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$users = $this->model_users->find($id);

		if (!empty($users->pp)) {
			$path = FCPATH . '/uploads/users/' . $users->pp;

			if (is_file($path)) {
				$delete_file = unlink($path);
			}
		}
		
		
		return $this->model_users->remove($id);
	}
	
	/**
	* Upload Image Users	* 
	* @return JSON
	*/
	public function upload_pp_file()
	{
		if (!$this->is_allowed('users_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}

		$uuid = $this->input->post('qquuid');

		echo $this->upload_file([
			'uuid' 		 	=> $uuid,
			'table_name' 	=> 'users',
		]);
	}

	/**
	* Delete Image Users	* 
	* @return JSON
	*/
	public function delete_pp_file($uuid)
	{
		if (!$this->is_allowed('users_delete', false)) {
			echo json_encode([
				'success' => false,
				'error' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}

		echo $this->delete_file([
            'uuid'              => $uuid, 
            'delete_by'         => $this->input->get('by'), 
            'field_name'        => 'pp', 
            'upload_path_tmp'   => './uploads/tmp/',
            'table_name'        => 'users',
            'primary_key'       => 'user_id',
            'upload_path'       => 'uploads/users/'
        ]);
	}

	/**
	* Get Image Users	* 
	* @return JSON
	*/
	public function get_pp_file($id)
	{
		if (!$this->is_allowed('users_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => 'Image not loaded, you do not have permission to access'
				]);
			exit;
		}

		$users = $this->model_users->find($id);

		echo $this->get_file([
            'uuid'              => $id, 
            'delete_by'         => 'id', 
            'field_name'        => 'pp', 
            'table_name'        => 'users',
            'primary_key'       => 'user_id',
            'upload_path'       => 'uploads/users/',
            'delete_endpoint'   => 'administrator/users/delete_pp_file'
        ]);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('users_export');

		$this->model_users->export(
			'users', 
			'users',
			$this->model_users->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('users_export');

		$this->model_users->pdf('users', 'users');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('users_export');

		$table = $title = 'users';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_users->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file users.php */
/* Location: ./application/controllers/administrator/Users.php */