<?php

namespace App\Http\Controllers;

use App\Models\Lead;
use App\Models\User;
use App\Models\TrackLead;
use App\Models\LeadStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LeadsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Lead::all();
    }

    public function getLeads(){
        $user = Auth::user();
        $emp_id = $user->employee_id;
        $lead = Lead::where('emp_id',$emp_id)->get();
        return response([
            'status'=> true,
            'message'=> 'Fetching all Leads Details',
            'data' => $lead,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required',
            'email'=>'required',
            'phone'=>'required',
            'address'=>'required',
            'status'=>'required',
            'city'=>'required',
            'state'=>'required',
            'country'=>'required',
        ]);
        return Lead::create($request->all()); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $lead = Lead::find($id);
        if(!empty($lead)){
            return response([
                'status'=>true,
                'message'=>'Get Leads Details',
                "data"=>$lead
            ],201); 
        }else{
            return response([
                'status'=>false,
                'message'=>'No Records Found',
                "data"=>[]
            ],201);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $lead = Lead::find($id);
        $lead->update($request->all());
        return $lead; 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $lead = Lead::find($id);
        return $lead->delete();
    }

    public function search($city)
    {
        return $lead = Lead::where('city',$city)->get();
    }

    public function getLeadsStatus(){
        $lead_status = LeadStatus::all();
        $status = $lead_status->pluck('status')->all();
        return response([
            'status'=>true,
            'message'=>'Fetch all Lead Status',
            'data'=> $status
        ]);
    }

    public function leadRemarks(Request $request){
        $request->validate([
            'mobile'=> 'required',
            'name'=> 'required',
            'status'=> 'required',
            'remarks'=> 'required',
        ]);
        $user = Auth::user();
        $lead_status = Lead::where(['phone'=>$request->mobile,'name'=>$request->name])->update([
            'status' => $request->status,
            'remarks' => $request->remarks,
        ]);
        $data = Lead::where(['phone'=>$request->mobile,'name'=>$request->name])->get();
        if($lead_status){
            return response([
                'status'=>true,
                'messgae'=>'Leads Status Updated Successfully',
                'data'=> $data
            ]);
        }else{
            return response([
                'status'=>false,
                'messgae'=>'No Records Found',
                'data'=> []
            ]);
        }

        
    }

}                                                                                                                           
