<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Test Leads Controller
*| --------------------------------------------------------------------------
*| Test Leads site
*|
*/
class Test_leads extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_test_leads');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Test Leadss
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('test_leads_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['test_leadss'] = $this->model_test_leads->get($filter, $field, $this->limit_page, $offset);
		$this->data['test_leads_counts'] = $this->model_test_leads->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/test_leads/index/',
			'total_rows'   => $this->data['test_leads_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Test Leads List');
		$this->render('backend/standart/administrator/test_leads/test_leads_list', $this->data);
	}
	
	/**
	* Add new test_leadss
	*
	*/
	public function add()
	{
		$this->is_allowed('test_leads_add');

		$this->template->title('Test Leads New');
		$this->render('backend/standart/administrator/test_leads/test_leads_add', $this->data);
	}

	/**
	* Add New Test Leadss
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('test_leads_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[255]');
		

		$this->form_validation->set_rules('code', 'Code', 'trim|required|max_length[255]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'code' => $this->input->post('code'),
			];

			
			
			$save_test_leads = $this->model_test_leads->store($save_data);
            

			if ($save_test_leads) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_test_leads;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/test_leads/edit/' . $save_test_leads, 'Edit Test Leads'),
						anchor('administrator/test_leads', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/test_leads/edit/' . $save_test_leads, 'Edit Test Leads')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/test_leads');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/test_leads');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Test Leadss
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('test_leads_update');

		$this->data['test_leads'] = $this->model_test_leads->find($id);

		$this->template->title('Test Leads Update');
		$this->render('backend/standart/administrator/test_leads/test_leads_update', $this->data);
	}

	/**
	* Update Test Leadss
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('test_leads_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[255]');
		

		$this->form_validation->set_rules('code', 'Code', 'trim|required|max_length[255]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'code' => $this->input->post('code'),
			];


			
			
			$save_test_leads = $this->model_test_leads->change($id, $save_data);

			if ($save_test_leads) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/test_leads', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/test_leads');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/test_leads');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Test Leadss
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('test_leads_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'test_leads'), 'success');
        } else {
            set_message(cclang('error_delete', 'test_leads'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Test Leadss
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('test_leads_view');

		$this->data['test_leads'] = $this->model_test_leads->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Test Leads Detail');
		$this->render('backend/standart/administrator/test_leads/test_leads_view', $this->data);
	}
	
	/**
	* delete Test Leadss
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$test_leads = $this->model_test_leads->find($id);

		
		
		return $this->model_test_leads->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('test_leads_export');

		$this->model_test_leads->export(
			'test_leads', 
			'test_leads',
			$this->model_test_leads->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('test_leads_export');

		$this->model_test_leads->pdf('test_leads', 'test_leads');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('test_leads_export');

		$table = $title = 'test_leads';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_test_leads->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file test_leads.php */
/* Location: ./application/controllers/administrator/Test Leads.php */