<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Manage Banners Controller
*| --------------------------------------------------------------------------
*| Manage Banners site
*|
*/
class Manage_banners extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_manage_banners');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Manage Bannerss
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('manage_banners_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['manage_bannerss'] = $this->model_manage_banners->get($filter, $field, $this->limit_page, $offset);
		$this->data['manage_banners_counts'] = $this->model_manage_banners->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/manage_banners/index/',
			'total_rows'   => $this->data['manage_banners_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Manage Banners List');
		$this->render('backend/standart/administrator/manage_banners/manage_banners_list', $this->data);
	}
	
	/**
	* Add new manage_bannerss
	*
	*/
	public function add()
	{
		$this->is_allowed('manage_banners_add');

		$this->template->title('Manage Banners New');
		$this->render('backend/standart/administrator/manage_banners/manage_banners_add', $this->data);
	}

	/**
	* Add New Manage Bannerss
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('manage_banners_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('manage_banners_img_uploads_name', 'Img Uploads', 'trim|required');
		

		

		if ($this->form_validation->run()) {
			$manage_banners_img_uploads_uuid = $this->input->post('manage_banners_img_uploads_uuid');
			$manage_banners_img_uploads_name = $this->input->post('manage_banners_img_uploads_name');
		
			$save_data = [
			];

			
			if (!is_dir(FCPATH . '/uploads/manage_banners/')) {
				mkdir(FCPATH . '/uploads/manage_banners/');
			}

			if (!empty($manage_banners_img_uploads_name)) {
				$manage_banners_img_uploads_name_copy = date('YmdHis') . '-' . $manage_banners_img_uploads_name;

				rename(FCPATH . 'uploads/tmp/' . $manage_banners_img_uploads_uuid . '/' . $manage_banners_img_uploads_name, 
						FCPATH . 'uploads/manage_banners/' . $manage_banners_img_uploads_name_copy);

				if (!is_file(FCPATH . '/uploads/manage_banners/' . $manage_banners_img_uploads_name_copy)) {
					echo json_encode([
						'success' => false,
						'message' => 'Error uploading file'
						]);
					exit;
				}

				$save_data['img_uploads'] = $manage_banners_img_uploads_name_copy;
			}
		
			
			$save_manage_banners = $this->model_manage_banners->store($save_data);
            

			if ($save_manage_banners) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_manage_banners;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/manage_banners/edit/' . $save_manage_banners, 'Edit Manage Banners'),
						anchor('administrator/manage_banners', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/manage_banners/edit/' . $save_manage_banners, 'Edit Manage Banners')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/manage_banners');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/manage_banners');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Manage Bannerss
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('manage_banners_update');

		$this->data['manage_banners'] = $this->model_manage_banners->find($id);

		$this->template->title('Manage Banners Update');
		$this->render('backend/standart/administrator/manage_banners/manage_banners_update', $this->data);
	}

	/**
	* Update Manage Bannerss
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('manage_banners_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('manage_banners_img_uploads_name', 'Img Uploads', 'trim|required');
		

		
		if ($this->form_validation->run()) {
			$manage_banners_img_uploads_uuid = $this->input->post('manage_banners_img_uploads_uuid');
			$manage_banners_img_uploads_name = $this->input->post('manage_banners_img_uploads_name');
		
			$save_data = [
			];


			
			if (!is_dir(FCPATH . '/uploads/manage_banners/')) {
				mkdir(FCPATH . '/uploads/manage_banners/');
			}

			if (!empty($manage_banners_img_uploads_uuid)) {
				$manage_banners_img_uploads_name_copy = date('YmdHis') . '-' . $manage_banners_img_uploads_name;

				rename(FCPATH . 'uploads/tmp/' . $manage_banners_img_uploads_uuid . '/' . $manage_banners_img_uploads_name, 
						FCPATH . 'uploads/manage_banners/' . $manage_banners_img_uploads_name_copy);

				if (!is_file(FCPATH . '/uploads/manage_banners/' . $manage_banners_img_uploads_name_copy)) {
					echo json_encode([
						'success' => false,
						'message' => 'Error uploading file'
						]);
					exit;
				}

				$save_data['img_uploads'] = $manage_banners_img_uploads_name_copy;
			}
		
			
			$save_manage_banners = $this->model_manage_banners->change($id, $save_data);

			if ($save_manage_banners) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/manage_banners', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/manage_banners');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/manage_banners');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Manage Bannerss
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('manage_banners_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'manage_banners'), 'success');
        } else {
            set_message(cclang('error_delete', 'manage_banners'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Manage Bannerss
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('manage_banners_view');

		$this->data['manage_banners'] = $this->model_manage_banners->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Manage Banners Detail');
		$this->render('backend/standart/administrator/manage_banners/manage_banners_view', $this->data);
	}
	
	/**
	* delete Manage Bannerss
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$manage_banners = $this->model_manage_banners->find($id);

		if (!empty($manage_banners->img_uploads)) {
			$path = FCPATH . '/uploads/manage_banners/' . $manage_banners->img_uploads;

			if (is_file($path)) {
				$delete_file = unlink($path);
			}
		}
		
		
		return $this->model_manage_banners->remove($id);
	}
	
	/**
	* Upload Image Manage Banners	* 
	* @return JSON
	*/
	public function upload_img_uploads_file()
	{
		if (!$this->is_allowed('manage_banners_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}

		$uuid = $this->input->post('qquuid');

		echo $this->upload_file([
			'uuid' 		 	=> $uuid,
			'table_name' 	=> 'manage_banners',
		]);
	}

	/**
	* Delete Image Manage Banners	* 
	* @return JSON
	*/
	public function delete_img_uploads_file($uuid)
	{
		if (!$this->is_allowed('manage_banners_delete', false)) {
			echo json_encode([
				'success' => false,
				'error' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}

		echo $this->delete_file([
            'uuid'              => $uuid, 
            'delete_by'         => $this->input->get('by'), 
            'field_name'        => 'img_uploads', 
            'upload_path_tmp'   => './uploads/tmp/',
            'table_name'        => 'manage_banners',
            'primary_key'       => 'id',
            'upload_path'       => 'uploads/manage_banners/'
        ]);
	}

	/**
	* Get Image Manage Banners	* 
	* @return JSON
	*/
	public function get_img_uploads_file($id)
	{
		if (!$this->is_allowed('manage_banners_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => 'Image not loaded, you do not have permission to access'
				]);
			exit;
		}

		$manage_banners = $this->model_manage_banners->find($id);

		echo $this->get_file([
            'uuid'              => $id, 
            'delete_by'         => 'id', 
            'field_name'        => 'img_uploads', 
            'table_name'        => 'manage_banners',
            'primary_key'       => 'id',
            'upload_path'       => 'uploads/manage_banners/',
            'delete_endpoint'   => 'administrator/manage_banners/delete_img_uploads_file'
        ]);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('manage_banners_export');

		$this->model_manage_banners->export(
			'manage_banners', 
			'manage_banners',
			$this->model_manage_banners->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('manage_banners_export');

		$this->model_manage_banners->pdf('manage_banners', 'manage_banners');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('manage_banners_export');

		$table = $title = 'manage_banners';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_manage_banners->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file manage_banners.php */
/* Location: ./application/controllers/administrator/Manage Banners.php */