<?php
defined('BASEPATH') or exit('No direct script access allowed');


/**
 *| --------------------------------------------------------------------------
 *| Leads Controller
 *| --------------------------------------------------------------------------
 *| Leads site
 *|
 */
class Leads extends Admin
{

	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_leads');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	 * show all Leadss
	 *
	 * @var $offset String
	 */
	public function index($offset = 0)
	{
		$this->is_allowed('leads_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['leadss'] = $this->model_leads->get($filter, $field, $this->limit_page, $offset);
		$this->data['leads_counts'] = $this->model_leads->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/leads/index/',
			'total_rows'   => $this->data['leads_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Leads List');
		$this->render('backend/standart/administrator/leads/leads_list', $this->data);
	}

	/**
	 * Add new leadss
	 *
	 */
	public function add()
	{
		$this->is_allowed('leads_add');

		$this->template->title('Leads New');
		$this->render('backend/standart/administrator/leads/leads_add', $this->data);
	}

	/**
	 * Add New Leadss
	 *
	 * @return JSON
	 */
	public function add_save()
	{
		if (!$this->is_allowed('leads_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}



		$this->form_validation->set_rules('emp_id', 'Emp Id', 'trim|max_length[255]');


		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[255]');


		$this->form_validation->set_rules('phone', 'Phone', 'trim|required|max_length[255]');


		$this->form_validation->set_rules('status', 'Status', 'trim|max_length[100]');


		$this->form_validation->set_rules('city', 'City', 'trim|max_length[100]');


		$this->form_validation->set_rules('remarks', 'Remarks', 'trim|max_length[500]');




		if ($this->form_validation->run()) {

			$save_data = [
				'emp_id' => $this->input->post('emp_id'),
				'name' => $this->input->post('name'),
				'phone' => $this->input->post('phone'),
				'status' => $this->input->post('status'),
				'city' => $this->input->post('city'),
				'remarks' => $this->input->post('remarks'),
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s'),
			];



			$save_leads = $this->model_leads->store($save_data);


			if ($save_leads) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_leads;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/leads/edit/' . $save_leads, 'Edit Leads'),
						anchor('administrator/leads', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
							anchor('administrator/leads/edit/' . $save_leads, 'Edit Leads')
						]),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/leads');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/leads');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * Update view Leadss
	 *
	 * @var $id String
	 */
	public function edit($id)
	{
		$this->is_allowed('leads_update');

		$this->data['leads'] = $this->model_leads->find($id);

		$this->template->title('Leads Update');
		$this->render('backend/standart/administrator/leads/leads_update', $this->data);
	}

	/**
	 * Update Leadss
	 *
	 * @var $id String
	 */
	public function edit_save($id)
	{
		if (!$this->is_allowed('leads_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}
		$this->form_validation->set_rules('emp_id', 'Emp Id', 'trim|max_length[255]');


		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[255]');


		$this->form_validation->set_rules('phone', 'Phone', 'trim|required|max_length[255]');


		$this->form_validation->set_rules('status', 'Status', 'trim|max_length[100]');


		$this->form_validation->set_rules('city', 'City', 'trim|max_length[100]');


		$this->form_validation->set_rules('remarks', 'Remarks', 'trim|max_length[500]');



		if ($this->form_validation->run()) {

			$save_data = [
				'emp_id' => $this->input->post('emp_id'),
				'name' => $this->input->post('name'),
				'phone' => $this->input->post('phone'),
				'status' => $this->input->post('status'),
				'city' => $this->input->post('city'),
				'remarks' => $this->input->post('remarks'),
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s'),
			];




			$save_leads = $this->model_leads->change($id, $save_data);

			if ($save_leads) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/leads', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', []),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/leads');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/leads');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * delete Leadss
	 *
	 * @var $id String
	 */
	public function delete($id = null)
	{
		$this->is_allowed('leads_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) > 0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
			set_message(cclang('has_been_deleted', 'leads'), 'success');
		} else {
			set_message(cclang('error_delete', 'leads'), 'error');
		}

		redirect_back();
	}

	/**
	 * View view Leadss
	 *
	 * @var $id String
	 */
	public function view($id)
	{
		$this->is_allowed('leads_view');

		$this->data['leads'] = $this->model_leads->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Leads Detail');
		$this->render('backend/standart/administrator/leads/leads_view', $this->data);
	}

	/**
	 * delete Leadss
	 *
	 * @var $id String
	 */
	private function _remove($id)
	{
		$leads = $this->model_leads->find($id);



		return $this->model_leads->remove($id);
	}


	/**
	 * Export to excel
	 *
	 * @return Files Excel .xls
	 */
	public function export()
	{
		$this->is_allowed('leads_export');





		$this->model_leads->export(
			'leads',
			'leads',
			$this->model_leads->field_search
		);
	}

	/**
	 * Export to PDF
	 *
	 * @return Files PDF .pdf
	 */
	public function export_pdf()
	{
		$this->is_allowed('leads_export');

		$this->model_leads->pdf('leads', 'leads');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('leads_export');

		$table = $title = 'leads';
		$this->load->library('HtmlPdf');

		$config = array(
			'orientation' => 'p',
			'format' => 'a4',
			'marges' => array(5, 5, 5, 5)
		);

		$this->pdf = new HtmlPdf($config);
		$this->pdf->setDefaultFont('stsongstdlight');

		$result = $this->db->get($table);

		$data = $this->model_leads->find($id);
		$fields = $result->list_fields();

		$content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
			'data' => $data,
			'fields' => $fields,
			'title' => $title
		], TRUE);

		$this->pdf->initialize($config);
		$this->pdf->pdf->SetDisplayMode('fullpage');
		$this->pdf->writeHTML($content);
		$this->pdf->Output($table . '.pdf', 'H');
	}
}


/* End of file leads.php */
/* Location: ./application/controllers/administrator/Leads.php */