<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Model_employee_reports extends MY_Model
{

    private $primary_key    = 'id';
    private $table_name     = 'employee_reports';
    public $field_search   = ['employee', 'total_leads', 'converted_leads', 'total_amount', 'converted_amount', 'total_follow_up', 'total_pending', 'created_at'];

    public function __construct()
    {
        $config = array(
            'primary_key'   => $this->primary_key,
            'table_name'    => $this->table_name,
            'field_search'  => $this->field_search,
        );

        parent::__construct($config);
    }

    public function count_all($q = null, $field = null)
    {
        $iterasi = 1;
        $num = count($this->field_search);
        $where = NULL;
        $q = $this->scurity($q);
        $field = $this->scurity($field);

        if (empty($field)) {
            foreach ($this->field_search as $field) {
                if ($iterasi == 1) {
                    $where .= "employee_reports." . $field . " LIKE '%" . $q . "%' ";
                } else {
                    $where .= "OR " . "employee_reports." . $field . " LIKE '%" . $q . "%' ";
                }
                $iterasi++;
            }

            $where = '(' . $where . ')';
        } else {
            $where .= "(" . "employee_reports." . $field . " LIKE '%" . $q . "%' )";
        }

        $this->join_avaiable()->filter_avaiable();
        $this->db->where($where);
        $query = $this->db->get($this->table_name);

        return $query->num_rows();
    }

    public function get($q = null, $field = null, $limit = 0, $offset = 0, $select_field = [])
    {
        $iterasi = 1;
        $num = count($this->field_search);
        $where = NULL;
        $q = $this->scurity($q);
        $field = $this->scurity($field);

        if (empty($field)) {
            foreach ($this->field_search as $field) {
                if ($iterasi == 1) {
                    $where .= "employee_reports." . $field . " LIKE '%" . $q . "%' ";
                } else {
                    $where .= "OR " . "employee_reports." . $field . " LIKE '%" . $q . "%' ";
                }
                $iterasi++;
            }

            $where = '(' . $where . ')';
        } else {
            $where .= "(" . "employee_reports." . $field . " LIKE '%" . $q . "%' )";
        }

        if (is_array($select_field) and count($select_field)) {
            $this->db->select($select_field);
        }

        $this->join_avaiable()->filter_avaiable();
        $this->db->where($where);
        $this->db->limit($limit, $offset);

        $this->sortable();

        $query = $this->db->get($this->table_name);

        return $query->result();
    }

    public function join_avaiable()
    {

        $this->db->select('employee_reports.*');


        return $this;
    }

    public function filter_avaiable()
    {

        if (!$this->aauth->is_admin()) {
        }

        return $this;
    }

    public function stores($data)
    {

        foreach ($data as $key => $value) {

            $this->db->select('*');
            $this->db->from('employee_reports');
            $this->db->where('employee', $value['employee']);
            $query = $this->db->get();


            if ($query->num_rows() > 0) {
                $this->db->where('employee', $value['employee']);
                $this->db->update('employee_reports', $value);
            } else {
                $this->db->insert('employee_reports', $value);
            }


            // $this->db->where('employee', $value['employee']);

        }






        //$this->db->insert_batch('employee_reports', $data);
    }
}

/* End of file Model_employee_reports.php */
/* Location: ./application/models/Model_employee_reports.php */