<?php
//ini_set('display_errors', '1');
defined('BASEPATH') or exit('No direct script access allowed');


/**
 *| --------------------------------------------------------------------------
 *| Employee Reports Controller
 *| --------------------------------------------------------------------------
 *| Employee Reports site
 *|
 */
class Employee_reports extends Admin
{

	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_employee_reports');
		$this->load->model('group/model_group');

		$this->lang->load('web_lang', $this->current_lang);
		$this->load->model('users/model_users');
		$this->load->model('leads/model_leads');
	}

	/**
	 * show all Employee Reportss
	 *
	 * @var $offset String
	 */
	public function index($offset = 0)
	{
		$this->is_allowed('employee_reports_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		//$this->data['employee_reportss'] = $this->model_employee_reports->get();
		//$this->data['employee_reports_counts'] = $this->model_employee_reports->count_all($filter, $field);
		$this->data['employee_reportss'] = $this->model_users->get($filter, $field, $this->limit_page, $offset);
		//print_r($this->data['employee_reportss']);

		$this->data['employee_report'] = $this->model_leads->getCount();

		$config = [
			'base_url'     => 'administrator/employee_reports/index/',
			'total_rows'   => $this->data['employee_reports_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Employee Reports List');
		$this->render('backend/standart/administrator/employee_reports/employee_reports_list', $this->data);
	}

	/**
	 * Add new employee_reportss
	 *
	 */
	public function add()
	{
		$this->is_allowed('employee_reports_add');

		$this->template->title('Employee Reports New');
		$this->render('backend/standart/administrator/employee_reports/employee_reports_add', $this->data);
	}

	/**
	 * Add New Employee Reportss
	 *
	 * @return JSON
	 */
	public function add_save()
	{
		if (!$this->is_allowed('employee_reports_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}
		// if ($this->input->post('sbt') == 'Send') {
		// 	$list_id = $this->input->post('employee');

		// }







		$this->form_validation->set_rules('employee', 'Employee', 'required');



		//$this->form_validation->set_rules('total_leads', 'Total Leads', 'trim|required');


		//$this->form_validation->set_rules('converted_leads', 'Converted Leads', 'trim|required');


		//$this->form_validation->set_rules('total_amount', 'Total Amount', 'trim|required');


		//$this->form_validation->set_rules('converted_amount', 'Converted Amount', 'trim|required');


		//$this->form_validation->set_rules('total_follow_up', 'Total Follow Up', 'trim|required');


		//$this->form_validation->set_rules('total_pending', 'Total Pending', 'trim|required');


		//$this->form_validation->set_rules('created_at', 'Created At', 'trim|required');





		if ($this->input->post('sbt') == 'Send') {

			$data = array();

			$count = count($this->input->post('employee'));

			for ($i = 0; $i < $count; $i++) {
				$data[] = array(
					'employee' => $this->input->post('employee')[$i],
					'total_leads' => $this->input->post('total_leads')[$i],
					'converted_leads' => $this->input->post('converted_leads')[$i],
					'total_pending' => $this->input->post('total_pending')[$i],
					'total_follow_up' => $this->input->post('total_follow_up')[$i],
				);
			}


			$save_employee_reports = $this->model_employee_reports->stores($data);
			$this->session->set_flashdata('msg', 'Room added');
			redirect('administrator/employee_reports');

			if ($save_employee_reports) {
				//$this->data['redirect'] = base_url('administrator/employee_reports');
			}

			$this->response($this->data);
		}
	}

	/**
	 * Update view Employee Reportss
	 *
	 * @var $id String
	 */
	public function edit($id)
	{
		$this->is_allowed('employee_reports_update');

		$this->data['employee_reports'] = $this->model_employee_reports->find($id);

		$this->template->title('Employee Reports Update');
		$this->render('backend/standart/administrator/employee_reports/employee_reports_update', $this->data);
	}

	/**
	 * Update Employee Reportss
	 *
	 * @var $id String
	 */
	public function edit_save($id)
	{
		if (!$this->is_allowed('employee_reports_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}
		$this->form_validation->set_rules('employee', 'Employee', 'trim|required');


		$this->form_validation->set_rules('total_leads', 'Total Leads', 'trim|required');


		$this->form_validation->set_rules('converted_leads', 'Converted Leads', 'trim|required');


		$this->form_validation->set_rules('total_amount', 'Total Amount', 'trim|required');


		$this->form_validation->set_rules('converted_amount', 'Converted Amount', 'trim|required');


		$this->form_validation->set_rules('total_follow_up', 'Total Follow Up', 'trim|required');


		$this->form_validation->set_rules('total_pending', 'Total Pending', 'trim|required');


		$this->form_validation->set_rules('created_at', 'Created At', 'trim|required');



		if ($this->form_validation->run()) {

			$save_data = [
				'employee' => $this->input->post('employee'),
				'total_leads' => $this->input->post('total_leads'),
				'converted_leads' => $this->input->post('converted_leads'),
				'total_amount' => $this->input->post('total_amount'),
				'converted_amount' => $this->input->post('converted_amount'),
				'total_follow_up' => $this->input->post('total_follow_up'),
				'total_pending' => $this->input->post('total_pending'),
				'created_at' => $this->input->post('created_at'),
			];




			$save_employee_reports = $this->model_employee_reports->change($id, $save_data);

			if ($save_employee_reports) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/employee_reports', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', []),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/employee_reports');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/employee_reports');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * delete Employee Reportss
	 *
	 * @var $id String
	 */
	public function delete($id = null)
	{
		$this->is_allowed('employee_reports_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) > 0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
			set_message(cclang('has_been_deleted', 'employee_reports'), 'success');
		} else {
			set_message(cclang('error_delete', 'employee_reports'), 'error');
		}

		redirect_back();
	}

	/**
	 * View view Employee Reportss
	 *
	 * @var $id String
	 */
	public function view($id)
	{
		$this->is_allowed('employee_reports_view');

		$this->data['employee_reports'] = $this->model_employee_reports->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Employee Reports Detail');
		$this->render('backend/standart/administrator/employee_reports/employee_reports_view', $this->data);
	}

	/**
	 * delete Employee Reportss
	 *
	 * @var $id String
	 */
	private function _remove($id)
	{
		$employee_reports = $this->model_employee_reports->find($id);



		return $this->model_employee_reports->remove($id);
	}


	/**
	 * Export to excel
	 *
	 * @return Files Excel .xls
	 */
	public function export()
	{
		$this->is_allowed('employee_reports_export');

		$this->model_employee_reports->export(
			'employee_reports',
			'employee_reports',
			$this->model_employee_reports->field_search
		);
	}

	/**
	 * Export to PDF
	 *
	 * @return Files PDF .pdf
	 */
	public function export_pdf()
	{
		$this->is_allowed('employee_reports_export');

		$this->model_employee_reports->pdf('employee_reports', 'employee_reports');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('employee_reports_export');

		$table = $title = 'employee_reports';
		$this->load->library('HtmlPdf');

		$config = array(
			'orientation' => 'p',
			'format' => 'a4',
			'marges' => array(5, 5, 5, 5)
		);

		$this->pdf = new HtmlPdf($config);
		$this->pdf->setDefaultFont('stsongstdlight');

		$result = $this->db->get($table);

		$data = $this->model_employee_reports->find($id);
		$fields = $result->list_fields();

		$content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
			'data' => $data,
			'fields' => $fields,
			'title' => $title
		], TRUE);

		$this->pdf->initialize($config);
		$this->pdf->pdf->SetDisplayMode('fullpage');
		$this->pdf->writeHTML($content);
		$this->pdf->Output($table . '.pdf', 'H');
	}

	public function add_form()
	{
		$employee = $this->input->post('employee');
		echo $employee;
		echo "hii";
		die();
	}
}


/* End of file employee_reports.php */
/* Location: ./application/controllers/administrator/Employee Reports.php */