<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Employee Report Controller
*| --------------------------------------------------------------------------
*| Employee Report site
*|
*/
class Employee_report extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_employee_report');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Employee Reports
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('employee_report_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['employee_reports'] = $this->model_employee_report->get($filter, $field, $this->limit_page, $offset);
		$this->data['employee_report_counts'] = $this->model_employee_report->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/employee_report/index/',
			'total_rows'   => $this->data['employee_report_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Employee Report List');
		$this->render('backend/standart/administrator/employee_report/employee_report_list', $this->data);
	}
	
	/**
	* Add new employee_reports
	*
	*/
	public function add()
	{
		$this->is_allowed('employee_report_add');

		$this->template->title('Employee Report New');
		$this->render('backend/standart/administrator/employee_report/employee_report_add', $this->data);
	}

	/**
	* Add New Employee Reports
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('employee_report_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('employee', 'Employee', 'trim|required|max_length[255]');
		

		$this->form_validation->set_rules('0', '', 'trim|required');
		

		$this->form_validation->set_rules('converted_leads', 'Converted Leads', 'trim|required');
		

		$this->form_validation->set_rules('total_amount', 'Total Amount', 'trim|required');
		

		$this->form_validation->set_rules('converted_amount', 'Converted Amount', 'trim|required');
		

		$this->form_validation->set_rules('total_follow_up', 'Total Follow Up', 'trim|required');
		

		$this->form_validation->set_rules('total_pending_follow', 'Total Pending Follow', 'trim|required');
		

		$this->form_validation->set_rules('created_at', 'Created At', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'employee' => $this->input->post('employee'),
				'0' => $this->input->post('0'),
				'converted_leads' => $this->input->post('converted_leads'),
				'total_amount' => $this->input->post('total_amount'),
				'converted_amount' => $this->input->post('converted_amount'),
				'total_follow_up' => $this->input->post('total_follow_up'),
				'total_pending_follow' => $this->input->post('total_pending_follow'),
				'created_at' => $this->input->post('created_at'),
			];

			
			
			$save_employee_report = $this->model_employee_report->store($save_data);
            

			if ($save_employee_report) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_employee_report;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/employee_report/edit/' . $save_employee_report, 'Edit Employee Report'),
						anchor('administrator/employee_report', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/employee_report/edit/' . $save_employee_report, 'Edit Employee Report')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/employee_report');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/employee_report');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Employee Reports
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('employee_report_update');

		$this->data['employee_report'] = $this->model_employee_report->find($id);

		$this->template->title('Employee Report Update');
		$this->render('backend/standart/administrator/employee_report/employee_report_update', $this->data);
	}

	/**
	* Update Employee Reports
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('employee_report_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('employee', 'Employee', 'trim|required|max_length[255]');
		

		$this->form_validation->set_rules('0', '', 'trim|required');
		

		$this->form_validation->set_rules('converted_leads', 'Converted Leads', 'trim|required');
		

		$this->form_validation->set_rules('total_amount', 'Total Amount', 'trim|required');
		

		$this->form_validation->set_rules('converted_amount', 'Converted Amount', 'trim|required');
		

		$this->form_validation->set_rules('total_follow_up', 'Total Follow Up', 'trim|required');
		

		$this->form_validation->set_rules('total_pending_follow', 'Total Pending Follow', 'trim|required');
		

		$this->form_validation->set_rules('created_at', 'Created At', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'employee' => $this->input->post('employee'),
				'0' => $this->input->post('0'),
				'converted_leads' => $this->input->post('converted_leads'),
				'total_amount' => $this->input->post('total_amount'),
				'converted_amount' => $this->input->post('converted_amount'),
				'total_follow_up' => $this->input->post('total_follow_up'),
				'total_pending_follow' => $this->input->post('total_pending_follow'),
				'created_at' => $this->input->post('created_at'),
			];


			
			
			$save_employee_report = $this->model_employee_report->change($id, $save_data);

			if ($save_employee_report) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/employee_report', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/employee_report');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/employee_report');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Employee Reports
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('employee_report_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'employee_report'), 'success');
        } else {
            set_message(cclang('error_delete', 'employee_report'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Employee Reports
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('employee_report_view');

		$this->data['employee_report'] = $this->model_employee_report->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Employee Report Detail');
		$this->render('backend/standart/administrator/employee_report/employee_report_view', $this->data);
	}
	
	/**
	* delete Employee Reports
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$employee_report = $this->model_employee_report->find($id);

		
		
		return $this->model_employee_report->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('employee_report_export');

		$this->model_employee_report->export(
			'employee_report', 
			'employee_report',
			$this->model_employee_report->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('employee_report_export');

		$this->model_employee_report->pdf('employee_report', 'employee_report');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('employee_report_export');

		$table = $title = 'employee_report';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_employee_report->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file employee_report.php */
/* Location: ./application/controllers/administrator/Employee Report.php */