<?php

require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['uploadfile'])) {
    $inputFileName = $_FILES['uploadfile']['tmp_name'];


    try {
        $spreadsheet = IOFactory::load($inputFileName);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        // Database configuration
        $dbHost = 'localhost';
        $dbName = 'devwuus2_zestjob';
        $dbUser = 'devwuus2_Zestjob';
        $dbPassword = 'QH*5v}ECUa^(';

        // Connect to the database
        $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName", $dbUser, $dbPassword);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Prepare the SQL statement
        $stmt = $pdo->prepare("INSERT INTO leads (emp_id, name, phone, city) VALUES (:emp_id, :name, :phone, :city)");

        // Skip the first row (header) and remove blank rows
        $dataToInsert = array_filter(array_slice($sheetData, 1));

        foreach ($dataToInsert as $row) {
            // Check if all required columns have non-empty values
            if (!empty($row['A']) || !empty($row['B']) || !empty($row['C']) || !empty($row['D']) || !empty($row['E']) || !empty($row['F']) || !empty($row['G']) || !empty($row['H'])) {
                // Access each cell value using $row['COLUMN_NAME']
                $emp_id = $row['A'];
                $name = $row['B'];
                $phone = $row['C'];
                $city = $row['D'];

                // Bind parameters and execute the statement
                $stmt->bindParam(':emp_id', $emp_id, PDO::PARAM_STR);
                $stmt->bindParam(':name', $name, PDO::PARAM_STR);
                $stmt->bindParam(':phone', $phone, PDO::PARAM_STR);
                $stmt->bindParam(':city', $city, PDO::PARAM_STR);
                $stmt->execute();
            }
        }

        echo json_encode(['status' => true, 'message' => 'File Imported successfully!']);
    } catch (\Exception $e) {
        echo json_encode(['status' => false, 'message' => 'Error: ' . $e->getMessage()]);
    }
}
