<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Employee Call Tracking Controller
*| --------------------------------------------------------------------------
*| Employee Call Tracking site
*|
*/
class Employee_call_tracking extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_employee_call_tracking');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Employee Call Trackings
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('employee_call_tracking_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['employee_call_trackings'] = $this->model_employee_call_tracking->get($filter, $field, $this->limit_page, $offset);
		$this->data['employee_call_tracking_counts'] = $this->model_employee_call_tracking->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/employee_call_tracking/index/',
			'total_rows'   => $this->data['employee_call_tracking_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Employee Call Tracking List');
		$this->render('backend/standart/administrator/employee_call_tracking/employee_call_tracking_list', $this->data);
	}
	
	/**
	* Add new employee_call_trackings
	*
	*/
	public function add()
	{
		$this->is_allowed('employee_call_tracking_add');

		$this->template->title('Employee Call Tracking New');
		$this->render('backend/standart/administrator/employee_call_tracking/employee_call_tracking_add', $this->data);
	}

	/**
	* Add New Employee Call Trackings
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('employee_call_tracking_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required');
		

		$this->form_validation->set_rules('mobile', 'Mobile', 'trim|required|max_length[255]');
		

		$this->form_validation->set_rules('incoming', 'Incoming', 'trim|required');
		

		$this->form_validation->set_rules('outgoing', 'Outgoing', 'trim|required');
		

		$this->form_validation->set_rules('missed', 'Missed', 'trim|required');
		

		$this->form_validation->set_rules('rejected', 'Rejected', 'trim|required');
		

		$this->form_validation->set_rules('never_attended_calls', 'Never Attended Calls', 'trim|required');
		

		$this->form_validation->set_rules('not_pickedup', 'Not Pickedup', 'trim|required');
		

		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'user_id' => $this->input->post('user_id'),
				'mobile' => $this->input->post('mobile'),
				'incoming' => $this->input->post('incoming'),
				'outgoing' => $this->input->post('outgoing'),
				'missed' => $this->input->post('missed'),
				'rejected' => $this->input->post('rejected'),
				'never_attended_calls' => $this->input->post('never_attended_calls'),
				'not_pickedup' => $this->input->post('not_pickedup'),
				'date' => $this->input->post('date'),
				'lead_id' => $this->input->post('lead_id'),
				'emp_id' => $this->input->post('emp_id'),
				'emp_mobile' => $this->input->post('emp_mobile'),
				'lead_mobile' => $this->input->post('lead_mobile'),
			];

			
			
			$save_employee_call_tracking = $this->model_employee_call_tracking->store($save_data);
            

			if ($save_employee_call_tracking) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_employee_call_tracking;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/employee_call_tracking/edit/' . $save_employee_call_tracking, 'Edit Employee Call Tracking'),
						anchor('administrator/employee_call_tracking', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/employee_call_tracking/edit/' . $save_employee_call_tracking, 'Edit Employee Call Tracking')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/employee_call_tracking');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/employee_call_tracking');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Employee Call Trackings
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('employee_call_tracking_update');

		$this->data['employee_call_tracking'] = $this->model_employee_call_tracking->find($id);

		$this->template->title('Employee Call Tracking Update');
		$this->render('backend/standart/administrator/employee_call_tracking/employee_call_tracking_update', $this->data);
	}

	/**
	* Update Employee Call Trackings
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('employee_call_tracking_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('user_id', 'User Id', 'trim|required');
		

		$this->form_validation->set_rules('mobile', 'Mobile', 'trim|required|max_length[255]');
		

		$this->form_validation->set_rules('incoming', 'Incoming', 'trim|required');
		

		$this->form_validation->set_rules('outgoing', 'Outgoing', 'trim|required');
		

		$this->form_validation->set_rules('missed', 'Missed', 'trim|required');
		

		$this->form_validation->set_rules('rejected', 'Rejected', 'trim|required');
		

		$this->form_validation->set_rules('never_attended_calls', 'Never Attended Calls', 'trim|required');
		

		$this->form_validation->set_rules('not_pickedup', 'Not Pickedup', 'trim|required');
		

		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'user_id' => $this->input->post('user_id'),
				'mobile' => $this->input->post('mobile'),
				'incoming' => $this->input->post('incoming'),
				'outgoing' => $this->input->post('outgoing'),
				'missed' => $this->input->post('missed'),
				'rejected' => $this->input->post('rejected'),
				'never_attended_calls' => $this->input->post('never_attended_calls'),
				'not_pickedup' => $this->input->post('not_pickedup'),
				'date' => $this->input->post('date'),
				'lead_id' => $this->input->post('lead_id'),
				'emp_id' => $this->input->post('emp_id'),
				'emp_mobile' => $this->input->post('emp_mobile'),
				'lead_mobile' => $this->input->post('lead_mobile'),
			];


			
			
			$save_employee_call_tracking = $this->model_employee_call_tracking->change($id, $save_data);

			if ($save_employee_call_tracking) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/employee_call_tracking', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/employee_call_tracking');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/employee_call_tracking');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Employee Call Trackings
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('employee_call_tracking_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'employee_call_tracking'), 'success');
        } else {
            set_message(cclang('error_delete', 'employee_call_tracking'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Employee Call Trackings
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('employee_call_tracking_view');

		$this->data['employee_call_tracking'] = $this->model_employee_call_tracking->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Employee Call Tracking Detail');
		$this->render('backend/standart/administrator/employee_call_tracking/employee_call_tracking_view', $this->data);
	}
	
	/**
	* delete Employee Call Trackings
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$employee_call_tracking = $this->model_employee_call_tracking->find($id);

		
		
		return $this->model_employee_call_tracking->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('employee_call_tracking_export');

		$this->model_employee_call_tracking->export(
			'employee_call_tracking', 
			'employee_call_tracking',
			$this->model_employee_call_tracking->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('employee_call_tracking_export');

		$this->model_employee_call_tracking->pdf('employee_call_tracking', 'employee_call_tracking');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('employee_call_tracking_export');

		$table = $title = 'employee_call_tracking';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_employee_call_tracking->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file employee_call_tracking.php */
/* Location: ./application/controllers/administrator/Employee Call Tracking.php */