<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function register(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
            'password' => 'required|confirmed',
            'fullname' => 'required',
            'address' => 'required',
            'city' => 'required',
            'pincode' => 'required',
            'state' => 'required',
            // 'email' => 'required',
            'email' => 'required|unique:users',
            // 'mobile' => 'required',
            'mobile' => 'required|unique:users',
        ]);
        //   return $request->all();
        $lastUser = User::latest('user_id')->first();
        if ($lastUser) {
            $luser = $lastUser->employee_id;
            $emp_id = 'ZHJ' . str_replace('ZHJ', '', $luser) + 1;
        } else {
            $emp_id = 'ZHJ1';
        }
        $user = User::create([
            'employee_id' => $emp_id,
            'user_name' => $request->user_name,
            'email' => $request->email,
            'mobile' => $request->mobile,
            'address1' => $request->address,
            'city' => $request->city,
            'state' => $request->state,
            'fullname' => $request->fullname,
            'password' => Hash::make($request->password),
        ]);

        $token = $user->createToken($request->user_name)->plainTextToken;

        return response([
            'status' => true,
            'message' => 'Registered Successfully',
            'data' => [
                'user' => $user,
                'token' => $token
            ]
        ], 201);
    }

    public function index()
    {
        return User::all();
    }

    public function logout()
    {
        auth()->user()->tokens()->delete();
        return response([
            'status' => true,
            'message' => 'Successfully Logged out!!',
            'data' => []
        ]);
    }

    public function login(Request $request)
    {
        $request->validate([
            'emp_id' => 'required',
            'password' => 'required'
        ]);

        $user = User::where('employee_id', $request->emp_id)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response([
                'status' => false,
                'message' => 'Invalid Credential',
                'data' => []
            ], 401);
        }
        // Credentials are valid, create a token and send the response
        $token = $user->createToken("$request->emp_id")->plainTextToken;

        return response([
            'status' => true,
            'message' => 'Successfully Logged in!!',
            'data' => [
                'user' => $user,
                'token' => $token
            ]
        ], 200);
    }
}
