<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LeadsController;
use App\Http\Controllers\UserController;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
// Route::middleware('auth:sanctum')->get('/lead',[LeadsController::class,'index']);
Route::post('/register', [UserController::class, 'register']);
Route::get('/login', [UserController::class, 'login']);
Route::middleware(['auth:sanctum'])->group(function () {
    Route::delete('/logout', [UserController::class, 'logout']);
    // Route::get('/lead', [LeadsController::class, 'index']);
    Route::get('/lead', [LeadsController::class, 'getLeads']);
    Route::get('/lead/{id}', [LeadsController::class, 'show']);
    Route::post('/lead', [LeadsController::class, 'store']);
    Route::put('/lead/{id}', [LeadsController::class, 'update']);
    Route::delete('/lead/{id}', [LeadsController::class, 'destroy']);
    Route::get('/lead/search/{city}', [LeadsController::class, 'search']);
    Route::post('/lead/status', [LeadsController::class, 'getLeadsStatus']);
    Route::post('/lead/remarks', [LeadsController::class, 'leadRemarks']);
    Route::get('/leads/{status}', [LeadsController::class, 'getStatus']);
    Route::get('/count', [LeadsController::class, 'getCount']);
    Route::get('/banner', [LeadsController::class, 'getBanner']);
    Route::get('/showlogs', [LeadsController::class, 'getCalender']);
});


// Route::get('/leads',function(){
//     return 'All leads Data';
// });
// Route::get('/lead',[LeadsController::class,'index']);
// Route::get('/lead/{id}',[LeadsController::class,'show']);
// Route::post('/lead',[LeadsController::class,'store']);
// Route::put('/lead/{id}',[LeadsController::class,'update']);
// Route::delete('/lead/{id}',[LeadsController::class,'destroy']);
// Route::get('/lead/search/{city}',[LeadsController::class,'search']);
