<?php
defined('BASEPATH') or exit('No direct script access allowed');


/**
 *| --------------------------------------------------------------------------
 *| Manage Banner Controller
 *| --------------------------------------------------------------------------
 *| Manage Banner site
 *|
 */
class Manage_banner extends Admin
{

	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_manage_banner');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	 * show all Manage Banners
	 *
	 * @var $offset String
	 */
	public function index($offset = 0)
	{
		$this->is_allowed('manage_banner_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['manage_banners'] = $this->model_manage_banner->get($filter, $field, $this->limit_page, $offset);
		$this->data['manage_banner_counts'] = $this->model_manage_banner->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/manage_banner/index/',
			'total_rows'   => $this->data['manage_banner_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Manage Banner List');
		$this->render('backend/standart/administrator/manage_banner/manage_banner_list', $this->data);
	}

	/**
	 * Add new manage_banners
	 *
	 */
	public function add()
	{
		$this->is_allowed('manage_banner_add');

		$this->template->title('Manage Banner New');
		$this->render('backend/standart/administrator/manage_banner/manage_banner_add', $this->data);
	}

	/**
	 * Add New Manage Banners
	 *
	 * @return JSON
	 */
	public function add_save()
	{
		if (!$this->is_allowed('manage_banner_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}



		$this->form_validation->set_rules('manage_banner_img_upload_name[]', 'Img Upload', 'trim|required');




		if ($this->form_validation->run()) {

			$save_data = [];


			if (!is_dir(FCPATH . '/uploads/manage_banner/')) {
				mkdir(FCPATH . '/uploads/manage_banner/');
			}

			if (count((array) $this->input->post('manage_banner_img_upload_name'))) {
				foreach ((array) $_POST['manage_banner_img_upload_name'] as $idx => $file_name) {
					$manage_banner_img_upload_name_copy = date('YmdHis') . '-' . $file_name;

					rename(
						FCPATH . 'uploads/tmp/' . $_POST['manage_banner_img_upload_uuid'][$idx] . '/' .  $file_name,
						FCPATH . 'uploads/manage_banner/' . $manage_banner_img_upload_name_copy
					);

					$listed_image[] = $manage_banner_img_upload_name_copy;

					if (!is_file(FCPATH . '/uploads/manage_banner/' . $manage_banner_img_upload_name_copy)) {
						echo json_encode([
							'success' => false,
							'message' => 'Error uploading file'
						]);
						exit;
					}
				}

				$save_data['img_upload'] = implode(',', $listed_image);
			}


			$save_manage_banner = $this->model_manage_banner->store($save_data);


			if ($save_manage_banner) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_manage_banner;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/manage_banner/edit/' . $save_manage_banner, 'Edit Manage Banner'),
						anchor('administrator/manage_banner', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
							anchor('administrator/manage_banner/edit/' . $save_manage_banner, 'Edit Manage Banner')
						]),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/manage_banner');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/manage_banner');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * Update view Manage Banners
	 *
	 * @var $id String
	 */
	public function edit($id)
	{
		$this->is_allowed('manage_banner_update');

		$this->data['manage_banner'] = $this->model_manage_banner->find($id);

		$this->template->title('Manage Banner Update');
		$this->render('backend/standart/administrator/manage_banner/manage_banner_update', $this->data);
	}

	/**
	 * Update Manage Banners
	 *
	 * @var $id String
	 */
	public function edit_save($id)
	{
		if (!$this->is_allowed('manage_banner_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}
		$this->form_validation->set_rules('manage_banner_img_upload_name[]', 'Img Upload', 'trim|required');



		if ($this->form_validation->run()) {

			$save_data = [];



			$listed_image = [];
			if (count((array) $this->input->post('manage_banner_img_upload_name'))) {
				foreach ((array) $_POST['manage_banner_img_upload_name'] as $idx => $file_name) {
					if (isset($_POST['manage_banner_img_upload_uuid'][$idx]) and !empty($_POST['manage_banner_img_upload_uuid'][$idx])) {
						$manage_banner_img_upload_name_copy = date('YmdHis') . '-' . $file_name;

						rename(
							FCPATH . 'uploads/tmp/' . $_POST['manage_banner_img_upload_uuid'][$idx] . '/' .  $file_name,
							FCPATH . 'uploads/manage_banner/' . $manage_banner_img_upload_name_copy
						);

						$listed_image[] = $manage_banner_img_upload_name_copy;

						if (!is_file(FCPATH . '/uploads/manage_banner/' . $manage_banner_img_upload_name_copy)) {
							echo json_encode([
								'success' => false,
								'message' => 'Error uploading file'
							]);
							exit;
						}
					} else {
						$listed_image[] = $file_name;
					}
				}
			}

			$save_data['img_upload'] = implode(',', $listed_image);


			$save_manage_banner = $this->model_manage_banner->change($id, $save_data);

			if ($save_manage_banner) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/manage_banner', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', []),
						'success'
					);

					$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/manage_banner');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/manage_banner');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}

	/**
	 * delete Manage Banners
	 *
	 * @var $id String
	 */
	public function delete($id = null)
	{
		$this->is_allowed('manage_banner_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) > 0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
			set_message(cclang('has_been_deleted', 'manage_banner'), 'success');
		} else {
			set_message(cclang('error_delete', 'manage_banner'), 'error');
		}

		redirect_back();
	}

	/**
	 * View view Manage Banners
	 *
	 * @var $id String
	 */
	public function view($id)
	{
		$this->is_allowed('manage_banner_view');

		$this->data['manage_banner'] = $this->model_manage_banner->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Manage Banner Detail');
		$this->render('backend/standart/administrator/manage_banner/manage_banner_view', $this->data);
	}

	/**
	 * delete Manage Banners
	 *
	 * @var $id String
	 */
	private function _remove($id)
	{
		$manage_banner = $this->model_manage_banner->find($id);


		if (!empty($manage_banner->img_upload)) {
			foreach ((array) explode(',', $manage_banner->img_upload) as $filename) {
				$path = FCPATH . '/uploads/manage_banner/' . $filename;

				if (is_file($path)) {
					$delete_file = unlink($path);
				}
			}
		}

		return $this->model_manage_banner->remove($id);
	}


	/**
	 * Upload Image Manage Banner	* 
	 * @return JSON
	 */
	public function upload_img_upload_file()
	{
		if (!$this->is_allowed('manage_banner_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}

		$uuid = $this->input->post('qquuid');

		echo $this->upload_file([
			'uuid' 		 	=> $uuid,
			'table_name' 	=> 'manage_banner',
		]);
	}

	/**
	 * Delete Image Manage Banner	* 
	 * @return JSON
	 */
	public function delete_img_upload_file($uuid)
	{
		if (!$this->is_allowed('manage_banner_delete', false)) {
			echo json_encode([
				'success' => false,
				'error' => cclang('sorry_you_do_not_have_permission_to_access')
			]);
			exit;
		}

		echo $this->delete_file([
			'uuid'              => $uuid,
			'delete_by'         => $this->input->get('by'),
			'field_name'        => 'img_upload',
			'upload_path_tmp'   => './uploads/tmp/',
			'table_name'        => 'manage_banner',
			'primary_key'       => 'id',
			'upload_path'       => 'uploads/manage_banner/'
		]);
	}

	/**
	 * Get Image Manage Banner	* 
	 * @return JSON
	 */
	public function get_img_upload_file($id)
	{
		if (!$this->is_allowed('manage_banner_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => 'Image not loaded, you do not have permission to access'
			]);
			exit;
		}

		$manage_banner = $this->model_manage_banner->find($id);

		echo $this->get_file([
			'uuid'              => $id,
			'delete_by'         => 'id',
			'field_name'        => 'img_upload',
			'table_name'        => 'manage_banner',
			'primary_key'       => 'id',
			'upload_path'       => 'uploads/manage_banner/',
			'delete_endpoint'   => 'administrator/manage_banner/delete_img_upload_file'
		]);
	}

	/**
	 * Export to excel
	 *
	 * @return Files Excel .xls
	 */
	public function export()
	{
		$this->is_allowed('manage_banner_export');

		$this->model_manage_banner->export(
			'manage_banner',
			'manage_banner',
			$this->model_manage_banner->field_search
		);
	}

	/**
	 * Export to PDF
	 *
	 * @return Files PDF .pdf
	 */
	public function export_pdf()
	{
		$this->is_allowed('manage_banner_export');

		$this->model_manage_banner->pdf('manage_banner', 'manage_banner');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('manage_banner_export');

		$table = $title = 'manage_banner';
		$this->load->library('HtmlPdf');

		$config = array(
			'orientation' => 'p',
			'format' => 'a4',
			'marges' => array(5, 5, 5, 5)
		);

		$this->pdf = new HtmlPdf($config);
		$this->pdf->setDefaultFont('stsongstdlight');

		$result = $this->db->get($table);

		$data = $this->model_manage_banner->find($id);
		$fields = $result->list_fields();

		$content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
			'data' => $data,
			'fields' => $fields,
			'title' => $title
		], TRUE);

		$this->pdf->initialize($config);
		$this->pdf->pdf->SetDisplayMode('fullpage');
		$this->pdf->writeHTML($content);
		$this->pdf->Output($table . '.pdf', 'H');
	}
}


/* End of file manage_banner.php */
/* Location: ./application/controllers/administrator/Manage Banner.php */