<?php

namespace App\Http\Controllers;

use App\Models\Lead;
use App\Models\User;
use App\Models\TrackLead;
use App\Models\LeadStatus;
use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Manage_banner;

class LeadsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Lead::all();
    }

    public function getLeads()
    {
        $user = Auth::user();
        $emp_id = $user->employee_id;
        // $emp_id = 'ZHJ5';
        $lead = Lead::where('emp_id', $emp_id)->where('status', '')->where('remarks', '')->get();
        // 


        return response([
            'status' => true,
            'message' => 'Fetching all Leads Details',
            // 'display' => false,
            'data' => $lead,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'status' => 'required',
            'city' => 'required',
            'state' => 'required',
            'country' => 'required',
        ]);
        return Lead::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $lead = Lead::find($id);
        if (!empty($lead)) {
            return response([
                'status' => true,
                'message' => 'Get Leads Details',
                "data" => $lead
            ], 201);
        } else {
            return response([
                'status' => false,
                'message' => 'No Records Found',
                "data" => []
            ], 201);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $lead = Lead::find($id);
        $lead->update($request->all());
        return $lead;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $lead = Lead::find($id);
        return $lead->delete();
    }

    public function search($city)
    {
        return $lead = Lead::where('city', $city)->get();
    }

    public function getLeadsStatus()
    {
        $lead_status = LeadStatus::all();
        $status = $lead_status->pluck('status')->all();
        return response([
            'status' => true,
            'message' => 'Fetch all Lead Status',
            'data' => $status
        ]);
    }

    public function leadRemarks(Request $request)
    {
        $request->validate([
            'mobile' => 'required',
            'name' => 'required',
            'status' => 'required',
            'remarks' => 'required',
        ]);



        $user = Auth::user();
        $lead_status = Lead::where(['phone' => $request->mobile, 'name' => $request->name])->update([
            'status' => $request->status,
            'remarks' => $request->remarks
        ]);

        $data = Lead::where(['phone' => $request->mobile, 'name' => $request->name])->get();

        if ($lead_status) {
            return response([
                'status' => true,
                'messgae' => 'Leads Status Updated Successfully',
                'data' => $data
            ]);
        } else {
            return response([
                'status' => false,
                'messgae' => 'No Records Found',
                'data' => []
            ]);
        }
    }

    public function getStatus(Request $request)
    {
        $request->validate([

            'status' => 'required',

        ]);


        $user = Auth::user();
        $lead = Lead::where(['status' => $request->status])->get();
        if ($user) {
            return response([
                'status' => true,
                'messgae' => 'Leads Status  Successfully',
                'data' => $lead
            ]);
        }
    }

    public function getCount()
    {


        $user = Auth::user();
        $lead = Lead::where(['status' => 'R N R'])->get();
        // $calllater = Lead::where(['status' => 'call later'])->get();
        $notinterest = Lead::where(['status' => 'Not Interested'])->get();
        $noresponse = Lead::where(['status' => 'no response'])->get();
        $busy = Lead::where(['status' => 'Bussy'])->get();
        $rejaion = Lead::where(['status' => 'Rejaion'])->get();
        $switchoff = Lead::where(['status' => 'Switch off'])->get();
        $interested = Lead::where(['status' => 'Interested'])->get();
        $not = Lead::where(['status' => 'Not Intrested'])->get();
        $data = array(
            'notintrested' => count($not),
            'noresponse' => count($noresponse),
            'swichoff' => count($switchoff),
            'RNR' => count($lead),
            'bussy' => count($busy),
            'interested' => count($interested),
            // 'calllater' => count($calllater),

            'notinterested' => count($notinterest),
            'rejaion' => count($rejaion),





        );
        if ($user) {
            return response([
                'status' => true,
                'messgae' => 'Leads Status  Successfully',
                'data' => $data
            ]);
        }
    }

    public function getBanner()
    {
        $lead_status = Banner::all();


        return response([
            'status' => true,
            'message' => 'Fetch all Lead Status',
            'data' => $lead_status
        ]);
    }

    public function getCalender(Request $request)
    {
        $user = Auth::user();


        // $lead = Lead::whereMonth('created_at', date('m'))->where(['status' => 'R N R'])->get();
        // $notinterest = Lead::whereMonth('created_at', date('m'))->where(['status' => 'Not Interested'])->get();
        // $noresponse = Lead::whereMonth('created_at', date('m'))->where(['status' => 'no response'])->get();
        // $busy = Lead::whereMonth('created_at', date('m'))->where(['status' => 'Bussy'])->get();
        // $rejaion = Lead::whereMonth('created_at', date('m'))->where(['status' => 'Rejaion'])->get();
        // $switchoff = Lead::whereMonth('created_at', date('m'))->where(['status' => 'Switch off'])->get();
        // $interested = Lead::whereMonth('created_at', date('m'))->where(['status' => 'Interested'])->get();
        // $not = Lead::whereMonth('created_at', date('m'))->where(['status' => 'Not Intrested'])->get();

        // $data = array(
        //     'notintrested' => count($not),
        //     'noresponse' => count($noresponse),
        //     'swichoff' => count($switchoff),
        //     'RNR' => count($lead),
        //     'bussy' => count($busy),
        //     'interested' => count($interested),
        //     // 'calllater' => count($calllater),

        //     'notinterested' => count($notinterest),
        //     'rejaion' => count($rejaion),

        // );

        //$lead = Lead::whereDay('created_at', date('d'))->where(['status' => 'R N R'])->get();

        // $lead = Lead::whereYear('created_at', date('Y'))->where(['status' => 'R N R'])->get();

        // $lead = Lead::whereDay('created_at', date('d') - 1)->where(['status' => 'R N R'])->get();
        // $lead = Lead::whereDay('created_at', date('d') - 6)->get();
        $request->validate([
            'show' => 'required',
        ]);

        if ($request->show == 'today') {
            $lead = Lead::whereDay('created_at', date('d') - 1)->where(['status' => 'R N R'])->get();
        } else {
            $lead = 'no response';
        }


        return response([
            'status' => true,
            'message' => 'Fetch all Lead Status',
            'data' => $lead
        ]);
    }
}
