 "use strict";
$(document).ready(function () {
    "use strict";
    var table = $('#editable-sample1').DataTable({
        responsive: true,
        //   dom: 'lfrBtip',

        "processing": true,
        "serverSide": true,
        "searchable": true,
        "ajax": {
            url: "prescription/getPrescriptionListByDoctor",
            type: 'POST',
        },
        scroller: {
            loadingIndicator: true
        },
        dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",

        buttons: [
            {extend: 'copyHtml5', exportOptions: {columns: [0, 1, 2], }},
            {extend: 'excelHtml5', exportOptions: {columns: [0, 1, 2], }},
            {extend: 'csvHtml5', exportOptions: {columns: [0, 1, 2], }},
            {extend: 'pdfHtml5', exportOptions: {columns: [0, 1, 2], }},
            {extend: 'print', exportOptions: {columns: [0, 1, 2], }},
        ],
        aLengthMenu: [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        iDisplayLength: 100,
        "order": [[0, "desc"]],
        "language": {
            "lengthMenu": "_MENU_",
            search: "_INPUT_",
            searchPlaceholder: "Search...",
            "url": "common/assets/DataTables/languages/" + language + ".json"
        },
    });
    table.buttons().container().appendTo('.custom_buttons');
});

$(document).ready(function () {
    "use strict";
    $(".flashmessage").delay(3000).fadeOut(100);
});

$(document).ready(function () {
    "use strict";
    $(".table").on("click", ".editPrescription", function () {
        "use strict";
        var iid = $(this).attr('data-id');
        $('#myModal5').modal('show');
        $.ajax({
            url: 'prescription/editPrescriptionByJason?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
            success: function (response) {
                "use strict";
                var de = response.prescription.date * 1000;
                var d = new Date(de);
                var da = (d.getDate() + 1) + '-' + (d.getMonth() + 1) + '-' + d.getFullYear();

                $('#prescriptionEditForm').find('[name="id"]').val(response.prescription.id).end();
                $('#prescriptionEditForm').find('[name="date"]').val(da).end();
                $('#prescriptionEditForm').find('[name="patient"]').val(response.prescription.patient).end();
                $('#prescriptionEditForm').find('[name="doctor"]').val(response.prescription.doctor).end();

               
                $('#prescriptionEditForm').find('[name="history"]').val(response.prescription.history).end();
                $('#prescriptionEditForm').find('[name="advice"]').val(response.prescription.advice).end();
                $('#prescriptionEditForm').find('[name="state"]').val(response.prescription.state).end();
                $('#prescriptionEditForm').find('[name="dd"]').val(response.prescription.dd).end();
                $('#prescriptionEditForm').find('[name="medicine"]').val(response.prescription.medicine).end();
                $('#prescriptionEditForm').find('[name="validity"]').val(response.prescription.validity).end();
                $('#prescriptionEditForm').find('[name="dd"]').val(response.prescription.dd).end();
                $('#prescriptionEditForm').find('[name="ipd_number"]').val(response.prescription.ipd_number).end();
                $('#prescriptionEditForm').find('[name="relative"]').val(response.prescription.relative).end();
                $('#prescriptionEditForm').find('[name="addmission_date"]').val(da).end();
                $('#prescriptionEditForm').find('[name="discharge_date"]').val(da).end();
                $('#prescriptionEditForm').find('[name="service"]').val(response.prescription.service).end();
                $('#prescriptionEditForm').find('[name="category"]').val(response.prescription.category).end();
                $('#prescriptionEditForm').find('[name="ward"]').val(response.prescription.ward).end();
                $('#prescriptionEditForm').find('[name="bed_no"]').val(response.prescription.bed_no).end();
                $('#prescriptionEditForm').find('[name="panel"]').val(response.prescription.panel).end();
                $('#prescriptionEditForm').find('[name="bp"]').val(response.prescription.bp).end();
                $('#prescriptionEditForm').find('[name="pulse"]').val(response.prescription.pulse).end();
                $('#prescriptionEditForm').find('[name="rr"]').val(response.prescription.rr).end();
                $('#prescriptionEditForm').find('[name="diabetes"]').val(response.prescription.diabetes).end();
                $('#prescriptionEditForm').find('[name="hypertension"]').val(response.prescription.hypertension).end();
                $('#prescriptionEditForm').find('[name="weight"]').val(response.prescription.weight).end();
                $('#prescriptionEditForm').find('[name="height"]').val(response.prescription.height).end();
                $('#prescriptionEditForm').find('[name="disease"]').val(response.prescription.disease).end();
                $('#prescriptionEditForm').find('[name="duration"]').val(response.prescription.duration).end();
                $('#prescriptionEditForm').find('[name="side"]').val(response.prescription.side).end();
                $('#prescriptionEditForm').find('[name="body_part"]').val(response.prescription.body_part).end();
                $('#prescriptionEditForm').find('[name="temperature"]').val(response.prescription.temperature).end();
                $('#prescriptionEditForm').find('[name="other"]').val(response.prescription.other).end();
                $('#prescriptionEditForm').find('[name="food_allergy"]').val(response.prescription.food_allergy).end();
                $('#prescriptionEditForm').find('[name="drug_allergy"]').val(response.prescription.drug_allergy).end();
                $('#prescriptionEditForm').find('[name="diagnosis"]').val(response.prescription.diagnosis).end();
                $('#prescriptionEditForm').find('[name="complaints"]').val(response.prescription.complaints).end();
                $('#prescriptionEditForm').find('[name="imprission"]').val(response.prescription.imprission).end();
                $('#prescriptionEditForm').find('[name="xray"]').val(response.prescription.xray).end();
                $('#prescriptionEditForm').find('[name="dd"]').val(response.prescription.dd).end();
                // $('#prescriptionEditForm').find('[name="medicine"]').val(response.prescription.medicine).end();
                


    
    
                myEditor1.setData(response.prescription.clinical_finding);               
                myEditor2.setData(response.prescription.symptom);
                myEditor3.setData(response.doctor.medicine);
                myEditor4.setData(response.doctor.note);

                $('.js-example-basic-single.doctor').val(response.prescription.doctor).trigger('change');
                $('.js-example-basic-single.patient').val(response.prescription.patient).trigger('change');
            }
        })
    });
});

