<style>
.box.box-solid.box-info {
    border: 1px solid #00c0ef;
}
.box {
    position: relative;
    border-radius: 3px;
    background: #ffffff;
    border-top: 3px solid #d2d6de;
    margin-bottom: 20px;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}
.box.box-solid.box-info>.box-header {
    color: #fff;
    background: #00c0ef;
    background-color: #00c0ef;
}
.box-header {
    color: #444;
    display: block;
    padding: 10px;
    position: relative;
}
header.with-border {
    border-bottom: none;
}


input.es-input {
    padding-right: 20px!important;
    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAICAYAAADJEc7MAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAG2YAABzjgAA4DIAAIM2AAB5CAAAxgwAADT6AAAgbL5TJ5gAAABGSURBVHjaYvz//z8DOYCJgUzA0tnZidPK8vJyRpw24pLEpwnuVHRFhDQxMDAwMPz//x+OOzo6/iPz8WFGuocqAAAA//8DAD/sORHYg7kaAAAAAElFTkSuQmCC) right center no-repeat;
}

select, textarea, input[type="text"], input[type="password"], input[type="datetime"], input[type="datetime-local"], input[type="date"], input[type="month"], input[type="time"], input[type="week"], input[type="number"], input[type="email"], input[type="url"], input[type="search"], input[type="tel"], input[type="color"], .uneditable-input {
    height: auto;
    margin-bottom: 0px;
}
.es-list {
    position: absolute;
    padding: 0;
    margin: 0;
    border: 1px solid #d1d1d1;
    display: none;
    z-index: 1000;
    background: #fff;
    max-height: 160px;
    overflow-y: auto;
    -moz-box-shadow: 0 2px 3px #ccc;
    -webkit-box-shadow: 0 2px 3px #ccc;
    box-shadow: 0 2px 3px #ccc;
}


.bootstrap-dialog .modal-header {
    border-top-left-radius: 4px;
    border-top-right-radius: 4px;
}
.modal-header {
    background-color: #428bca;
    min-height: 16.43px;
    padding: 15px;
    border-bottom: 1px solid #e5e5e5;
}
.bootstrap-dialog-title{
    color: white;
}
.modal-content{
    border: none;
}
.col-sm-12{
    padding:0px 25px!important
}
.btn-info{
    color:black!important;
    background:#3c8dbc;
}
</style>
<link href="common/extranal/css/prescription/professional.css" rel="stylesheet">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<section id="main-content">
    <section class="wrapper site-min-height">
        <div id="error" style="display:none; margin-top:20px!important" class="alert alert-danger text-center mt-3 mb-3 text-danger"></div>
        <div id="succ" style="display:none; margin-top:20px!important" class="alert alert-success text-center mt-3 mb-3 text-success"></div>
        <!-- page start-->
        <section class="panel col-md-12 row panel-heading_appoinment" style="margin:10px;padding:0px;">
            
            <div class="container" style="padding:0px;">
                
<div id="wrapper" style="width:100%;">
    <div id="tabContainer">
        
        <div style="padding-bottom:10px;border-bottom: 1px solid #f4f4f4;">
            <h3 style="margin:0px;">Prescription</h3>
        </div>
        <div id="tabs" style="margin-top:10px;">
            <ul>
                <li id="tabHeader_1">Patient</li>
                <li id="tabHeader_3">Symptom</li>
                <li id="tabHeader_2">Past History</li>
                
                <li id="tabHeader_4">Diagnosis</li>
                <li id="tabHeader_5">Tests</li>
                
                <li id="tabHeader_7">Medicine</li>
                <li id="tabHeader_6">Advices</li>
            </ul>
        </div>
        
        <div id="tabscontent" >
            <form action="prescription/addNewPrescription" id="myForm" method="post">
            <div class="tabpage" id="tabpage_1">
                <div class="box box-primary box-solid ">
                    <div class="box-header with-border">
                        <h4 class="box-title" style="margin:0px;">Patient Detail</h4>
                    </div>
                    <div class="" style="float: unset;margin-bottom:20px;padding:10px;">
                                <!--<label for="exampleInputEmail1"> <?php echo lang('patient'); ?> &#42;</label>-->
                                <?php if (!$this->ion_auth->in_group(array('Patient'))) { ?>
                                    <select class="form-control m-bot15  pos_select" id="pos_select" name="patient" value=''>
                                        <?php if (!empty($appointment)) { ?>
                                       
                                          <option value="<?php echo $patients->id; ?>" selected="selected"><?php echo $patients->name; ?> - <?php echo $patients->id; ?></option>
                                        <?php } ?>
                                    </select>
                                <?php } else {
                                  
                                    $user = $this->ion_auth->get_user_id();
                                    $patients = $this->db->get_where('patient', array('ion_user_id' => $user))->row();
                                ?>
                                    <select class="form-control m-bot15 pos_select" id="pos_select" name="patient" value=''>
                                        <option value="<?php echo $patients->id; ?>" selected="selected"><?php echo $patients->name; ?> - <?php echo $patients->id; ?></option>
                                    </select>
                                <?php } ?>
                           
                        
                            <input type="hidden" name="redirectlink" value="10">
                            </div>
                            <!--<div class="form-group col-md-6 form_data" style="height: 65px;">-->
                            <!--    </div>-->
                               
                        <div class="pos_client clearfix" style="display:none;border: 1px solid gainsboro;padding: 15px 0px;margin: 10px;">
                        
                                <div class="form-group col-md-4 form_data">
                                    <div style="border: 1px solid #80808030;padding: 10px;">
                                        <img id="blah" src="http://placehold.it/180" style="width:100px;margin-bottom: 10px;" height='85' alt="your image" />
                                        <input type="file" name="patient_image" onchange="readURL(this);" style="width: -webkit-fill-available;" />
                                    </div>
                                </div>
                                <div class="form-group col-md-8 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('name'); ?> &#42;</label>
                               
                               
                                    <input type="text" class="form-control pay_in" name="p_name" value='<?php
                                        if (!empty($payment->p_name)) {
                                            echo $payment->p_name;
                                        }
                                        ?>' placeholder="">
                                
                                </div>
                            
                             <!--   <div class="form-group col-md-12 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('email'); ?> </label>
                               
                                    <input type="text" class="form-control pay_in" name="p_email" value='<?php
                                        if (!empty($payment->p_email)) {
                                            echo $payment->p_email;
                                        }
                                        ?>' placeholder="">
                                
                            </div>-->
                           
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('phone'); ?> </label>
                                
                                    <input type="text" class="form-control pay_in" name="p_phone" value='<?php
                                    if (!empty($payment->p_phone)) {
                                        echo $payment->p_phone;
                                    }
                                    ?>' placeholder="">
                               
                                </div>
                                
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('email'); ?> </label>
                                
                                    <input type="email" class="form-control pay_in" name="email" value='<?php
                                    if (!empty($payment->email)) {
                                        echo $payment->email;
                                    }
                                    ?>' placeholder="">
                               
                                </div>
                    
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('gender'); ?></label>
                                
                                    <select class="form-control" name="p_gender" value=''>
    
                                        <option value="Male" <?php
                                                                if (!empty($patient->sex)) {
                                                                    if ($patient->sex == 'Male') {
                                                                        echo 'selected';
                                                                    }
                                                                }
                                                                ?>> <?php echo lang('male'); ?> </option>
                                        <option value="Female" <?php
                                                                if (!empty($patient->sex)) {
                                                                    if ($patient->sex == 'Female') {
                                                                        echo 'selected';
                                                                    }
                                                                }
                                                                ?>> <?php echo lang('female'); ?> </option>
                                        <option value="Other" <?php
                                                                if (!empty($patient->sex)) {
                                                                    if ($patient->sex == 'Other') {
                                                                        echo 'selected';
                                                                    }
                                                                }
                                                                ?>> Other </option>
    
                                    </select>
                                
                                </div>
                                
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> ID proof Type</label>
                                
                                    <select class="form-control" name="id_proof_type" value=''>
    
                                        <option value="Aadhar Card" <?php
                                                                if (!empty($patient->id_proof_type)) {
                                                                    if ($patient->id_proof_type == 'Aadhar Card') {
                                                                        echo 'selected';
                                                                    }
                                                                }
                                                                ?>>Aadhar Card </option>
                                        <option value="Voter ID" <?php
                                                                if (!empty($patient->id_proof_type)) {
                                                                    if ($patient->id_proof_type == 'Voter ID') {
                                                                        echo 'selected';
                                                                    }
                                                                }
                                                                ?>> Voter ID</option>
    
                                    </select>
                                
                                </div>
    
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> ID Proof No.</label>
                                
                                    <input type="text" class="form-control pay_in" name="id_proof" value='<?php
                                    if (!empty($payment->p_phone)) {
                                        echo $payment->p_phone;
                                    }
                                    ?>' placeholder="">
                               
                                </div>
                          
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('age'); ?></label>
                                
                                    <input type="text" class="form-control pay_in" name="p_age" value='<?php
                                        if (!empty($payment->p_age)) {
                                            echo $payment->p_age;
                                        }
                                        ?>' placeholder="">
                               
                                </div>
                                
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> Blood Group</label>
                                
                                    <input type="text" class="form-control pay_in" name="bloodgroup" value='<?php
                                        if (!empty($payment->bloodgroup)) {
                                            echo $payment->bloodgroup;
                                        }
                                        ?>' placeholder="">
                               
                                </div>
                                
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1"> State</label>
                                
                                    <input type="text" class="form-control pay_in" name="state" value='<?php
                                        if (!empty($payment->state)) {
                                            echo $payment->state;
                                        }
                                        ?>' placeholder="">
                               
                                </div>
                                
                                <div class="form-group col-md-4 form_data">
                                    <label for="exampleInputEmail1">City</label>
                                
                                    <input type="text" class="form-control pay_in" name="city" value='<?php
                                        if (!empty($payment->city)) {
                                            echo $payment->city;
                                        }
                                        ?>' placeholder="">
                               
                                </div>
                                <div class="form-group col-md-8 form_data">
                                    <label for="exampleInputEmail1">Address</label>
                                
                                    <input type="text" class="form-control pay_in" name="address" value='<?php
                                        if (!empty($payment->address)) {
                                            echo $payment->address;
                                        }
                                        ?>' placeholder="">
                               
                                </div>
                                
                                
                                
                        </div>
                    </div>
                </div>
                <div class="tabpage" id="tabpage_2" style="display:none;">
                    <div class="box box-primary box-solid ">
                        <div class="box-header with-border">
                            <h4 class="box-title" style="margin:0px;">Past Medical History</h4>
                        </div>
                        <div style="padding:15px;">
                            <div class="form-group">
                                <div class="col-md-6 col-sm-6 " style="padding:10px;">
                                    <label for="comment">History:</label>
                                </div>
                                <div class="col-md-6 col-sm-6 ">
                                    <a data-toggle="modal" href="#sympmod2" id="hist2" class="btn btn-danger btn-md pull-right" tabindex="9" >
                                        <i class="fa fa-history"></i> History
                                    </a>
                                </div>
                              <textarea class="form-control" style="height: 80px !important;" name="history" rows="5" id="comment"></textarea>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="tabpage" id="tabpage_3" style="display:none;">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Symptoms/Complaints</h4>
                                </div>
                                <div class="box-body  presc-box-body" style="padding:10px;">
                                    <div class="row presc-search-div">
                                        <div class="col-md-9 col-sm-10 form-group">
                                            <div class="input-group ">
                                               
                                                <select style="height: auto!important;" class="form-control input-md ui-autocomplete-input" id="pos_symptoms" name="" value=''>
                                                    
                                                   
                                                      <option value="" selected="selected"></option>
                                                    
                                                </select>

                                                <span class="input-group-btn">
                                                    <button type="button" tabindex="8" class="btn btn-default btn-flat btn-md"><i class="fa fa-plus"></i>
                                                        Add</button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-2 ">
                                            <a data-toggle="modal" href="#sympmod" id="hist" class="btn btn-danger btn-md pull-right" tabindex="9" >
                                                <i class="fa fa-history"></i> History
                                            </a>
                                        </div>

                                    </div>
                                    <div class="row" style="margin-top:20px;">
                                        <div class="col-md-6"><label>Select Symptoms/Complaint</label></div>
                                        <div class="col-md-6">
                                            <div id="symptomsCountDiv"><font color="red">No Symptom selected</font></div>
                                        </div>
                                    </div>
                                    <div id="symptomsDiv" class="presc-select-div presc-box-scroll">
                                        
                                    </div>
                                    <div class="row col-md-12" style="margin-top:20px;">
                                        <div id="symptomsDetailsPanel" class="hidden">
                                            <label>
                                                Symptom :&nbsp;
                                            </label><strong><span id="symptomsDetailsPanelHeading" style="color:#1323e7;"></span></strong>
                                            <div class="row">
                                                <input type="hidden" id="symptomsDetailId" name="symptomsDetailId">
                                                <div class="col-md-6">
                                                    <label>
                                                        Since
                                                    </label>
                                                    <input type="text" maxlength="50" class="form-control" id="symptomsDuration" tabindex="11">
                                                </div>
                                                <div class="col-md-6">
                                                    <label>
                                                        Severity
                                                    </label><br>
                                                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_0" value="0" tabindex="11">
                                                            Normal
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_1" value="1" tabindex="11">
                                                            Mild
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_2" value="2" tabindex="11" checked=""> Moderate
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_3" value="3" tabindex="11">
                                                            High
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <label>Note</label>
                                                    <input type="text" class="form-control" name="symptomsNote" id="symptomsNote" tabindex="11" placeholder="Write something here">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Selected Symptoms/Complaints</h4>
                                </div>
                                <div class="box-body presc-box-body presc-box-scroll">
                                    <!---->
                                    <div v-else="">
                                        <div id="noSymptomsSeletedDiv" style="padding: 5px 10px;">
                                            <div class="row text-center">
                                                <h4 id="symptomssel" class="display-2">No Symptom/Complaint Selected!</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tabpage" id="tabpage_4" style="display:none;">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Diagnosis</h4>
                                </div>
                                <div class="box-body  presc-box-body" style="padding:10px;">
                                    <div class="row presc-search-div">
                                        <div class="col-md-9 col-sm-10 form-group">
                                            <div class="input-group ">
                                               
                                                <select style="height: auto!important;" class="form-control input-md ui-autocomplete-input" id="pos_symptoms2" name="" value=''>
                                                    
                                                   
                                                      <option value="" selected="selected"></option>
                                                    
                                                </select>

                                                <span class="input-group-btn">
                                                    <button type="button" tabindex="8" class="btn btn-default btn-flat btn-md"><i class="fa fa-plus"></i>
                                                        Add</button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-2 ">
                                            <a data-toggle="modal" href="#sympmod3" id="hist3" class="btn btn-danger btn-md pull-right" tabindex="9">
                                                <i class="fa fa-history"></i> History
                                            </a>
                                        </div>

                                    </div>
                                    <div class="row" style="margin-top:20px;">
                                        <div class="col-md-6"><label>Select Diagnosis/Complaint</label></div>
                                        <div class="col-md-6">
                                            <div id="symptoms2CountDiv"><font color="red">No Diagnosis selected</font></div>
                                        </div>
                                    </div>
                                    <div id="symptoms2Div" class="presc-select-div presc-box-scroll">
                                        
                                    </div>
                                    <div class="row col-md-12" style="margin-top:20px;">
                                        <div id="symptoms2DetailsPanel" class="hidden">
                                            <label>
                                                Symptom :&nbsp;
                                            </label><strong><span id="symptoms2DetailsPanelHeading" style="color:#1323e7;"></span></strong>
                                            <div class="row">
                                                <input type="hidden" id="symptoms2DetailId" name="symptoms2DetailId">
                                                <div class="col-md-6">
                                                    <label>
                                                        Since
                                                    </label>
                                                    <input type="text" maxlength="50" class="form-control" id="symptoms2Duration" tabindex="11">
                                                </div>
                                                <div class="col-md-6">
                                                    <label>
                                                        Severity
                                                    </label><br>
                                                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_0" value="0" tabindex="11">
                                                            Normal
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_1" value="1" tabindex="11">
                                                            Mild
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_2" value="2" tabindex="11" checked=""> Moderate
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_3" value="3" tabindex="11">
                                                            High
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <label>Note</label>
                                                    <input type="text" class="form-control" name="symptoms2Note" id="symptoms2Note" tabindex="11" placeholder="Write something here">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Selected Diagnosis</h4>
                                </div>
                                <div class="box-body presc-box-body presc-box-scroll">
                                    <!---->
                                    <div v-else="">
                                        <div id="nosymptoms2SeletedDiv" style="padding: 5px 10px;">
                                            <div class="row text-center">
                                                <h4 id="symptoms2sel" class="display-2">No Diagnosis Seleted!</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tabpage" id="tabpage_5" style="display:none;">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Procedure/Lab Tests</h4>
                                </div>
                                <div class="box-body  presc-box-body" style="padding:10px;">
                                    <div class="row presc-search-div">
                                        <div class="col-md-9 col-sm-10 form-group">
                                            <div class="input-group ">
                                               
                                                <select style="height: auto!important;" class="form-control input-md ui-autocomplete-input" id="pos_symptoms3" name="" value=''>
                                                    
                                                   
                                                      <option value="" selected="selected"></option>
                                                    
                                                </select>

                                                <span class="input-group-btn">
                                                    <button type="button" tabindex="8" class="btn btn-default btn-flat btn-md"><i class="fa fa-plus"></i>
                                                        Add</button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-2 ">
                                            <a data-toggle="modal" href="#sympmod4" id="hist4" class="btn btn-danger btn-md pull-right" tabindex="9">
                                                <i class="fa fa-history"></i> History
                                            </a>
                                        </div>

                                    </div>
                                    <div class="row" style="margin-top:20px;">
                                        <div class="col-md-6"><label>Select Test/Complaint</label></div>
                                        <div class="col-md-6">
                                            <div id="symptoms3CountDiv"><font color="red">No Procedure selected</font></div>
                                        </div>
                                    </div>
                                    <div id="symptoms3Div" class="presc-select-div presc-box-scroll">
                                        
                                    </div>
                                    <div class="row col-md-12" style="margin-top:20px;">
                                        <div id="symptoms3DetailsPanel" class="hidden">
                                            <label>
                                                Symptom :&nbsp;
                                            </label><strong><span id="symptoms3DetailsPanelHeading" style="color:#1323e7;"></span></strong>
                                            <div class="row">
                                                <input type="hidden" id="symptoms3DetailId" name="symptoms3DetailId">
                                                <div class="col-md-6">
                                                    <label>
                                                        Since
                                                    </label>
                                                    <input type="text" maxlength="50" class="form-control" id="symptoms3Duration" tabindex="11">
                                                </div>
                                                <div class="col-md-6">
                                                    <label>
                                                        Severity
                                                    </label><br>
                                                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_0" value="0" tabindex="11">
                                                            Normal
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_1" value="1" tabindex="11">
                                                            Mild
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_2" value="2" tabindex="11" checked=""> Moderate
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_3" value="3" tabindex="11">
                                                            High
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <label>Note</label>
                                                    <input type="text" class="form-control" name="symptoms3Note" id="symptoms3Note" tabindex="11" placeholder="Write something here">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Selected Procedures/Lab Tests</h4>
                                </div>
                                <div class="box-body presc-box-body presc-box-scroll">
                                    <!---->
                                    <div v-else="">
                                        <div id="nosymptoms3SeletedDiv" style="padding: 5px 10px;">
                                            <div class="row text-center">
                                                <h4 id="symptoms3sel" class="display-2">No Procedure/Lab Test Seleted!</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tabpage" id="tabpage_6" style="display:none;">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Advise/Remarks</h4>
                                </div>
                                <div class="box-body  presc-box-body" style="padding:10px;">
                                    <div class="row presc-search-div">
                                        <div class="col-md-9 col-sm-10 form-group">
                                            <div class="input-group ">
                                               
                                                <select style="height: auto!important;" class="form-control input-md ui-autocomplete-input" id="pos_symptoms4" name="" value='' >
                                                    
                                                   
                                                      <option value="" selected="selected"></option>
                                                    
                                                </select>

                                                <span class="input-group-btn">
                                                    <button type="button" tabindex="8" class="btn btn-default btn-flat btn-md"><i class="fa fa-plus"></i>
                                                        Add</button>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-sm-2 ">
                                            <a data-toggle="modal" href="#sympmod5" id="hist5" class="btn btn-danger btn-md pull-right" tabindex="9">
                                                <i class="fa fa-history"></i> History
                                            </a>
                                        </div>

                                    </div>
                                    <div class="row" style="margin-top:20px;">
                                        <div class="col-md-6"><label>Select Advice/Complaint</label></div>
                                        <div class="col-md-6">
                                            <div id="symptoms4CountDiv"><font color="red">No Advise selected</font></div>
                                        </div>
                                    </div>
                                    <div id="symptoms4Div" class="presc-select-div presc-box-scroll">
                                        
                                    </div>
                                    <div class="row col-md-12" style="margin-top:20px;">
                                        <div id="symptoms4DetailsPanel" class="hidden">
                                            <label>
                                                Symptom :&nbsp;
                                            </label><strong><span id="symptoms4DetailsPanelHeading" style="color:#1323e7;"></span></strong>
                                            <div class="row">
                                                <input type="hidden" id="symptoms4DetailId" name="symptoms4DetailId">
                                                <div class="col-md-6">
                                                    <label>
                                                        Since
                                                    </label>
                                                    <input type="text" maxlength="50" class="form-control" id="symptoms4Duration" tabindex="11">
                                                </div>
                                                <div class="col-md-6">
                                                    <label>
                                                        Severity
                                                    </label><br>
                                                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_0" value="0" tabindex="11">
                                                            Normal
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_1" value="1" tabindex="11">
                                                            Mild
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_2" value="2" tabindex="11" checked=""> Moderate
                                                        </label>
                                                        <label class="btn btn-success">
                                                            <input type="radio" name="severityLevel" id="severityLevel_3" value="3" tabindex="11">
                                                            High
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <label>Note</label>
                                                    <input type="text" class="form-control" name="symptoms4Note" id="symptoms4Note" tabindex="11" placeholder="Write something here">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Selected Advise/Remarks</h4>
                                </div>
                                <div class="box-body presc-box-body presc-box-scroll">
                                    <!---->
                                    <div v-else="">
                                        <div id="nosymptoms4SeletedDiv" style="padding: 5px 10px;">
                                            <div class="row text-center">
                                                <h4 id="symptoms4sel" class="display-2">No Advise/Remark Seleted!</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                </div>
                <div class="tabpage" id="tabpage_7" style="display:none;">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="box box-primary box-solid ">
                                <div class="box-header with-border">
                                    <h4 class="box-title" style="margin:0px;">Medicine</h4>
                                </div>
                                <div class="box-body " style="padding:10px;">

                                        <div class="row">
                                            <div class="col-md-12" style="justify-content: right; text-align:right;">
                                                <a data-toggle="modal" href="#medimod" class="btn btn-info btn-md " style="margin-right: 10px; margin-bottom: 10px; " tabindex="9" id="showQuickMedicines">
                                                    <span><i class="fa fa-medkit" aria-hidden="true" data-toggle="tooltip" title="Quick Medicine Reference"></i>
                                                        Quick Medicine</span></a>
                                            </div>
                                            <div class="col-md-12">
                                                <div id="rxTable_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer"></div>
                                                <table id="rxTable" class="rxTable table table-striped table-bordered configbox table-responsive dataTable no-footer" cellspacing="0" width="100%">
                                                    <thead>
                                                        <tr role="row">
                                                            <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="Medicine Name
                                                                    *
                                                                
                                                            " style="width: 40%;">Medicine Name<font color="red">
                                                                    <sup>*</sup>
                                                                </font>
                                                            </th>
                                                            <th class="sorting" tabindex="0" aria-controls="rxTable" rowspan="1" colspan="1" aria-label="Dosage: activate to sort column ascending" style="width: 10%;">Dosage</th>
                                                            <th class="sorting" tabindex="0" aria-controls="rxTable" rowspan="1" colspan="1" aria-label="Preference/When: activate to sort column ascending" style="width: 15%;">Preference/When</th>
                                                            <th class="sorting" tabindex="0" aria-controls="rxTable" rowspan="1" colspan="1" aria-label="Frequency: activate to sort column ascending" style="width: 10%;">Frequency</th>
                                                            <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="Duration " style="width: 5%;">Duration <button id="copydurations" title="Copy first medicine days to all medicines"><i class="fa fa-copy"></i></button></th>
                                                            <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="comments" style="width: 15%;">Comments</th>
                                                            <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="" style="width: 5%;"></th>
                                                        </tr>
                                                    </thead>

                                                <tbody>
                                                    <tr id="1" role="row" class="odd">
                                                        <td>
                                                            <select style="height: auto!important;" id="med1" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('2')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="2" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med2" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('2')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="3" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med3" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('3')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="4" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med4" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('4')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="5" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med5" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('5')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="6" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med6" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('6')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="7" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med7" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('7')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="8" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med8" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('8')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="9" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med8" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('9')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    <tr id="10" role="row" class="odd" style="display:none">
                                                        <td>
                                                            <select style="height: auto!important;" id="med10" class="form-control input-md ui-autocomplete-input med_search" name="medicine[]" value='' >
                                                    
                                                   
                                                              <option value="" selected="selected"></option>
                                                            
                                                            </select>
                                                        </td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="dosage[]" id="frequency_1"><option value="">Select</option><option value="1-1-1">1-1-1</option><option value="1-1-0">1-1-0</option><option value="1-0-1">1-0-1</option><option value="0-1-1">0-1-1</option><option value="1-0-0">1-0-0</option><option value="0-0-1">0-0-1</option><option value="0-1-0">0-1-0</option><option value="0-0-0">0-0-0</option><option value="1/2 - 1/2 - 1/2">1/2 - 1/2 - 1/2</option><option value="1/2 - 1/2 - 1">1/2 - 1/2 - 1</option><option value="1/2 - 0 - 1/2">1/2 - 0 - 1/2</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" tabindex="37" name="instruction[]" id="preference_1"><option value="">Select</option><option>Before Meal</option><option >After Meal</option><option >Before Breakfast</option><option>After Breakfast</option><option>Before Lunch</option><option>After Lunch</option><option>Before Dinner</option><option>After Dinner</option><option>Before Breakfast and Dinner</option><option value="abd">After Breakfast and Dinner</option><option >Before Breakfast and Lunch</option><option >After Breakfast and Lunch</option><option >Before Lunch and Dinner</option><option value="After Lunch and Dinner">After Lunch and Dinner</option><option value="When required">When required</option></select></td>
                                                        <td><select onchange="onChangeSelect(this)" class="form-control" style="width:100%;padding:6px 0px;" tabindex="38" name="frequency[]" id="frequency_1"><option value="">Select</option><option value="Daily">Daily</option><option value="Alternate">Alternate</option><option>Weekly</option><option>Fortnight</option><option value="When required">When required</option></select></td>
                                                        <td><input type="number" tabindex="39" min="0" class="form-control" style="padding:6px 6px;" name="days[]" value="" id="days_1" placeholder="Enter days"></td>
                                                        <td><input type="text" style="padding:6px 4px;" tabindex="40" class="form-control" name="comments[]" value="" id="comments_1"></td>
                                                        <td><a class="btn btn-danger btn-xs " onclick="rem_med('10')" title="Delete Medicine" tabindex="41"><i class="fa fa-trash fa-lg"> </i></a>
                                                        </td>
                                                    </tr>
                                                    
                                                </tbody>
                                            </table>
                                            </div>
                                            <div class='col-sm-12'>
                                                <button type="button" class="btn btn-warning btn-flat" id="save" onclick="addmed();" tabindex="102" style="float:right;margin-right:15px;margin-top: 10px;">Add Medicine</button>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class='row' style="margin-top: 8px;">
                    <div class='col-sm-2' style="width:auto;margin-top: 8px;">
                        <label >Next Visit Date :</label>
                    </div>
                    <div class='col-sm-3' id="all_fields">
                        
                        <input type='text' class="form-control" id='datetimepicker4' name="next_visit" />
                    </div>
                    <div class='col-sm-7'>
                        <button type="submit" class="btn btn-primary btn-flat" id="save"  tabindex="102" style="float:right;margin-right:15px;">Save</button>
                    </div>
                    
                </div>
                
                <script type="text/javascript">
                     $(function () {
                         $('#datetimepicker4').datepicker();
                     });
                </script>
                </form>
            </div>
            </form>
        </div>
    </div>
</div>
        </section>
        <!-- page end-->
    </section>
</section>



<div class="modal fade" id="sympmod" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">  
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="65e4f718-7824-458c-a592-c6a23335b90f_title">Previous Symptoms</div>
                </div>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-hover table-bordered" id="symptoms" style="width:100%;">
                        <thead>
                            <tr>
                                
                                <th> <?php echo lang('date'); ?></th>   
                                <th> <?php echo lang('patient'); ?> <?php echo lang('id'); ?> </th>
                                <th> <?php echo lang('patient'); ?></th>
                                <th> <?php echo lang('prescription'); ?> <?php echo lang('id'); ?> </th>
                                <th> Symptoms</th>
                                <!--<th> <?php echo lang('options'); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                    </tbody>
                </table>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<div class="modal fade" id="sympmod2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">  
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="65e4f718-7824-458c-a592-c6a23335b90f_title">Previous Diagnosis</div>
                </div>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-hover table-bordered" id="symptoms2" style="width:100%;">
                        <thead>
                            <tr>
                                
                                <th> <?php echo lang('date'); ?></th>   
                                <th> <?php echo lang('patient'); ?> <?php echo lang('id'); ?> </th>
                                <th> <?php echo lang('patient'); ?></th>
                                <th> <?php echo lang('prescription'); ?> <?php echo lang('id'); ?> </th>
                                <th> Diagnosis</th>
                                <!--<th> <?php echo lang('options'); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                    </tbody>
                </table>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<div class="modal fade" id="sympmod3" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">  
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="65e4f718-7824-458c-a592-c6a23335b90f_title">Previous Test & Procedures</div>
                </div>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-hover table-bordered" id="symptoms3" style="width:100%;">
                        <thead>
                            <tr>
                                
                                <th> <?php echo lang('date'); ?></th>   
                                <th> <?php echo lang('patient'); ?> <?php echo lang('id'); ?> </th>
                                <th> <?php echo lang('patient'); ?></th>
                                <th> <?php echo lang('prescription'); ?> <?php echo lang('id'); ?> </th>
                                <th> Tests</th>
                                <!--<th> <?php echo lang('options'); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                    </tbody>
                </table>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<div class="modal fade" id="sympmod4" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">  
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="65e4f718-7824-458c-a592-c6a23335b90f_title">Previous Advice</div>
                </div>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-hover table-bordered" id="symptoms4" style="width:100%;">
                        <thead>
                            <tr>
                                
                                <th> <?php echo lang('date'); ?></th>   
                                <th> <?php echo lang('patient'); ?> <?php echo lang('id'); ?> </th>
                                <th> <?php echo lang('patient'); ?></th>
                                <th> <?php echo lang('prescription'); ?> <?php echo lang('id'); ?> </th>
                                <th> Advice</th>
                                <!--<th> <?php echo lang('options'); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                    </tbody>
                </table>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<div class="modal fade" id="sympmod5" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">  
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="65e4f718-7824-458c-a592-c6a23335b90f_title">Previous Advice</div>
                </div>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-hover table-bordered" id="symptoms5" style="width:100%;">
                        <thead>
                            <tr>
                                
                                <th> <?php echo lang('date'); ?></th>   
                                <th> <?php echo lang('patient'); ?> <?php echo lang('id'); ?> </th>
                                <th> <?php echo lang('patient'); ?></th>
                                <th> <?php echo lang('prescription'); ?> <?php echo lang('id'); ?> </th>
                                <th> Advice</th>
                                <!--<th> <?php echo lang('options'); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                    </tbody>
                </table>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<div class="modal fade" id="medimod" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">  
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="65e4f718-7824-458c-a592-c6a23335b90f_title">Previous Advice</div>
                </div>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-hover table-bordered" id="showQuickMedicine" style="width:100%;">
                        <thead>
                            <tr>
                                
                                <th> <?php echo lang('date'); ?></th>   
                                <th> <?php echo lang('patient'); ?> <?php echo lang('id'); ?> </th>
                                <th> <?php echo lang('patient'); ?></th>
                                <th> <?php echo lang('prescription'); ?> <?php echo lang('id'); ?> </th>
                                <th> Advice</th>
                                <!--<th> <?php echo lang('options'); ?></th>-->
                            </tr>
                        </thead>
                        <tbody>
                    </tbody>
                </table>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>


<script src="common/extranal/js/prescription/professional.js"></script>
<!--main content end-->
<!--footer start-->
<script type="text/javascript">
    var select_patient = "<?php echo lang('select_patient'); ?>";
</script>

<script src="common/extranal/js/appointment/appointment_select2.js"></script>
<script src="common/js/codearistos.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script type="text/javascript">var language = "<?php echo $this->language; ?>";</script>

<script>

$("#medicinee2").select2({

  createTag: function (params) {
    var term = $.trim(params.term);

    if (term === '') {
      return null;
    }

    return {
      id: medicinee2,
      text: term,
      newTag: true // add additional parameters
    }
  }
  

});

var i=1;

// for getting value of multi select

$("#medicinee2").on('change', function (e) {

    //this returns all the selected item
    var items= $(this).val();    

    if(items.length > 0)
    
    {
            $('#medicine2').empty();
            
            for (let i = 0; i < items.length; i++) {
              
                // for iterating the dynamic field based on the medicine present
                
                $("#medicine2").append('<section id="med_selected_section-' + items[items.length-1] + '" class="med_selected row">\n\
                 <div class = "form-group medicine_sect col-md-2"><div class=col-md-12>\n\
                <label> <?php echo lang("medicine"); ?> </label>\n\
                </div>\n\
                \n\
                <div class=col-md-12>\n\
                <input class = "medi_div" name = "med_name" value="' + items[i] + '" placeholder="" required>\n\
                 </div>\n\
                 </div>\n\
                \n\
                <div class = "form-group medicine_sect col-md-2" ><div class=col-md-12>\n\
                <label><?php echo lang("dosage"); ?> </label>\n\
                </div>\n\
                <div class=col-md-12><input class = "state medi_div" name = "dosage[]" value = "" placeholder="100 mg" required>\n\
                 </div>\n\
                 </div>\n\
                \n\
                <div class = "form-group medicine_sect col-md-2"><div class=col-md-12>\n\
                <label><?php echo lang("frequency"); ?> </label>\n\
                </div>\n\
                <div class=col-md-12><input class = "potency medi_div sale" id="" name = "frequency[]" value = "" placeholder="1 + 0 + 1" required>\n\
                </div>\n\
                </div>\n\
                \n\
                <div class = "form-group medicine_sect col-md-2"><div class=col-md-12>\n\
                <label>\n\
                <?php echo lang("days"); ?> \n\
                </label>\n\
                </div>\n\
                <div class=col-md-12><input class = "potency medi_div quantity" id="days" name = "days[]" value = "" placeholder="7 days" required>\n\
                </div>\n\
                </div>\n\
                \n\
                \n\<div class = "form-group medicine_sect col-md-2"><div class=col-md-12>\n\
                <label>\n\
                <?php echo lang("instruction"); ?> \n\
                </label>\n\
                </div>\n\
                <div class=col-md-12><input class = "potency medi_div quantity" id="instruction" name = "instruction[]" value = "" placeholder="After Food" required>\n\
                </div>\n\
                </div>\n\
                \n\
                \n\
                 <div class="del col-md-1"></div>\n\
                </section>');
                
            }
         
    }
        else
    {
        $('#medicine2').empty();
    }
})


</script>
<script>

window.onload=function() {

    // get tab container
    var container = document.getElementById("tabContainer");
    var tabcon = document.getElementById("tabscontent");
    // set current tab
    var navitem = document.getElementById("tabHeader_1");

    //store which tab we are on
    var ident = navitem.id.split("_")[1];
    //alert(ident);
    navitem.parentNode.setAttribute("data-current",ident);
    //set current tab with class of activetabheader
    navitem.setAttribute("class","tabActiveHeader");

    //hide two tab contents we don't need

    var pages = tabcon.getElementsByClassName("tabpage");
    for (var i = 0; i < pages.length; i++) {
        var comp=i+1;
        if(ident!=comp) {
            pages.item(i).style.display = "none";
        }
    };

    //this adds click event to tabs
    var tabs = container.getElementsByTagName("li");
    for (var i = 0; i < tabs.length; i++) {
        tabs[i].onclick=displayPage;
    }
}

// on click of one of tabs
function displayPage() {
    var current = this.parentNode.getAttribute("data-current");
    //remove class of activetabheader and hide old contents
    document.getElementById("tabHeader_" + current).removeAttribute("class");
    document.getElementById("tabpage_" + current).style.display="none";

    var ident = this.id.split("_")[1];

    //add class of activetabheader to new active tab and show contents
    this.setAttribute("class","tabActiveHeader");
    document.getElementById("tabpage_" + ident).style.display="block";
    this.parentNode.setAttribute("data-current",ident);
}

</script>

<script>
function rem_med(aaa)
{
    $("#med2").val()="";
    //$('#'+aaa).hide();
   
}
</script>

<script>

var target = $("div#target");
var n = function() {
  return $("div.col-xs-2").length;
};
var newInput = function() {
  var div = $("<div/>", {
    "class": "input-group"
  });
  var input = $("<input>", {
    "class": "form-control"
  });
  var span = $("<span/>", {
    "class": "input-group-btn"
  });
  var button = $("<button/>", {
    "class": "removeBtn btn btn-sm btn-link",
    type: "button",
    id: n()
  });
  var glyph = $("<span/>", {
    "class": "glyphicon glyphicon-remove"
  });
  var col = $("<div/>", {
    "class": "form-group col-xs-12 mt-2",
    id: "newInput-" + n()
  });

  $(glyph).appendTo(button);
  $(button).appendTo(span);
  $(input).appendTo(div);
  $(span).appendTo(div);
  $(div).appendTo(col);
  return col;
};

$('button#add').on('click', function() {
  $(newInput()).appendTo(target);
});

$('#target').on('click', 'button', function() {
  var target = $("#target").find("#newInput-" + this.id);
  $(target).remove();
});
</script>

<script>
const arr_list=[""];
var all_count=0;
var symptoms_counts=0;
$(document).ready(function(){
    $("#pos_symptoms").change(function(){
        $('#symptomssel').hide();
        var yy=$("#pos_symptoms").val();
        if($("#pos_symptoms").val()!='')
        {
            symptoms_counts++;
            all_count++;
            tmm=all_count.toString();
            arr_list.push(tmm);
            console.log(arr_list);
            $("#symptomsDiv").append("<div class='btn-group' style='margin: 2px;'><input type='button' onclick='toggleSymptomsButton(this)' tabindex='10' class='btn select-btn popButton btn-info' id='symptoms_"+all_count+"' value='"+yy+"' name='symptoms[]'><button type='button' onclick='removeSymptomsDetail(this)' id='symptomsDelete_"+all_count+"' tabindex='10' class='btn select-btn  btn-primary'><i class='fa fa-close'>&#10005;</i></button></div>");
            $("#noSymptomsSeletedDiv").append("<div id='sym_"+all_count+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptomsDetailDelete_"+all_count+"' onclick='removeSymptomsDetail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
            $("#all_fields").append("<div id='symt1"+tmm+"'><input type='hidden' name='symptoms[]' value='"+yy+"'></div>");
            symptomscounts();
        }
    });
});

function toggleSymptomsButton(btn) {
    
    $(btn).toggleClass('btn-info', true);
    $(btn).toggleClass('btn-default', false);
    let btnId = $(btn).attr('id');
    qq=arr_list.includes(btnId.split('_')[1]);
    if(qq==false)
    {
        arr_list.push(btnId.split('_')[1]);
        
        console.log(arr_list);
        symDeletebtn = $('#symptomsDelete_' + btnId.spflit('_')[1]);
        symDeletebtn.toggleClass('btn-primary', true);
        symDeletebtn.toggleClass('btn-default', false);
        symDeletebtn.prop({ disabled: false });
        var vvv1=$("#symptoms_"+btnId.split('_')[1]).val();
        $("#noSymptomsSeletedDiv").append("<div id='sym_"+btnId.split('_')[1]+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptomsDetailDelete_"+btnId.split('_')[1]+"' onclick='removeSymptomsDetail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
        symptomscounts();
        const element = document.getElementById("symt1"+btnId.split('_')[1]);
        element.remove();
    }

}
function removeSymptomsDetail(btn) {
    let btnId = $(btn).attr('id');
    symbtn = $('#symptoms_' + btnId.split('_')[1]);
    //symbtn.toggleClass('btn-info', false);
    symbtn.toggleClass('btn-default', true);
    $(btn).toggleClass('btn-default', true);
    $(btn).toggleClass('btn-primary', false);
    $(btn).prop({ disabled: true });
    $('#sym_' + btnId.split('_')[1]).remove();
    all_count--;
    symptomscounts();
    arr_list.splice(btnId.split('_')[1], 1);
    console.log(arr_list);
    const element = document.getElementById("symt1"+btnId.split('_')[1]);
    element.remove();
}
function symptomscounts()
{
    document.getElementById("symptomsCountDiv").innerHTML="<font color='#bb2525'><b>"+symptoms_counts+"</b></font> Symptoms selected";
}
</script>

<script>
var symptoms2_counts=0;
$(document).ready(function(){
    $("#pos_symptoms2").change(function(){
        $('#symptoms2sel').hide();
        var yy=$("#pos_symptoms2").val();
        if($("#pos_symptoms2").val()!='')
        {
            symptoms2_counts++;
            all_count++;
            tmm=all_count.toString();
            arr_list.push(tmm);
            $("#symptoms2Div").append("<div class='btn-group' style='margin: 2px;'><input type='button' onclick='togglesymptoms2Button(this)' tabindex='10' class='btn select-btn popButton btn-info' id='symptoms2_"+all_count+"' value='"+yy+"' name='symptoms2'><button type='button' onclick='removesymptoms2Detail(this)' id='symptoms2Delete_"+all_count+"' tabindex='10' class='btn select-btn  btn-primary'><i class='fa fa-close'>&#10005;</i></button></div>");
            $("#nosymptoms2SeletedDiv").append("<div id='sym_"+all_count+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptoms2DetailDelete_"+all_count+"' onclick='removesymptoms2Detail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
            $("#all_fields").append("<div id='symt2"+tmm+"'><input type='hidden' name='diagnosis[]' value='"+yy+"'></div>");
            symptoms2counts();
        }
    });
});

function togglesymptoms2Button(btn) {
    
    $(btn).toggleClass('btn-info', true);
    $(btn).toggleClass('btn-default', false);
    let btnId = $(btn).attr('id');
    qq=arr_list.includes(btnId.split('_')[1]);
    if(qq==false)
    {
        arr_list.push(btnId.split('_')[1]);
        
        console.log(arr_list);
        symDeletebtn = $('#symptoms2Delete_' + btnId.split('_')[1]);
        symDeletebtn.toggleClass('btn-primary', true);
        symDeletebtn.toggleClass('btn-default', false);
        symDeletebtn.prop({ disabled: false });
        var vvv1=$("#symptoms2_"+btnId.split('_')[1]).val();
        $("#nosymptoms2SeletedDiv").append("<div id='sym_"+btnId.split('_')[1]+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptoms2DetailDelete_"+btnId.split('_')[1]+"' onclick='removesymptoms2Detail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
        symptoms2counts();
        const element = document.getElementById("symt2"+btnId.split('_')[1]);
        element.remove();
    }

}
function removesymptoms2Detail(btn) {
    let btnId = $(btn).attr('id');
    symbtn = $('#symptoms2_' + btnId.split('_')[1]);
    symbtn.toggleClass('btn-info', false);
    symbtn.toggleClass('btn-default', true);
    $(btn).toggleClass('btn-default', true);
    $(btn).toggleClass('btn-primary', false);
    $(btn).prop({ disabled: true });
    $('#sym_' + btnId.split('_')[1]).remove();
    all_count--;
    symptoms2counts();
    arr_list.splice(btnId.split('_')[1], 1);
    const element = document.getElementById("symt2"+btnId.split('_')[1]);
    element.remove();
}
function symptoms2counts()
{
    document.getElementById("symptoms2CountDiv").innerHTML="<font color='#bb2525'><b>"+symptoms2_counts+"</b></font> symptoms2 selected";
}
</script>

<script>
var symptoms3_counts=0;
$(document).ready(function(){
    $("#pos_symptoms3").change(function(){
        $('#symptoms3sel').hide();
        var yy=$("#pos_symptoms3").val();
        if($("#pos_symptoms3").val()!='')
        {
            symptoms3_counts++;
            all_count++;
            tmm=all_count.toString();
            arr_list.push(tmm);
            $("#symptoms3Div").append("<div class='btn-group' style='margin: 2px;'><input type='button' onclick='togglesymptoms3Button(this)' tabindex='10' class='btn select-btn popButton btn-info' id='symptoms3_"+all_count+"' value='"+yy+"' name='symptoms3'><button type='button' onclick='removesymptoms3Detail(this)' id='symptoms3Delete_"+all_count+"' tabindex='10' class='btn select-btn  btn-primary'><i class='fa fa-close'>&#10005;</i></button></div>");
            $("#nosymptoms3SeletedDiv").append("<div id='sym_"+all_count+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptoms3DetailDelete_"+all_count+"' onclick='removesymptoms3Detail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
            $("#all_fields").append("<div id='symt3"+tmm+"'><input type='hidden' name='tests[]' value='"+yy+"'></div>");
            symptoms3counts();
        }
    });
});

function togglesymptoms3Button(btn) {
    
    $(btn).toggleClass('btn-info', true);
    $(btn).toggleClass('btn-default', false);
    let btnId = $(btn).attr('id');
    qq=arr_list.includes(btnId.split('_')[1]);
    if(qq==false)
    {
        arr_list.push(btnId.split('_')[1]);
        
        console.log(arr_list);
        symDeletebtn = $('#symptoms3Delete_' + btnId.split('_')[1]);
        symDeletebtn.toggleClass('btn-primary', true);
        symDeletebtn.toggleClass('btn-default', false);
        symDeletebtn.prop({ disabled: false });
        var vvv1=$("#symptoms3_"+btnId.split('_')[1]).val();
        $("#nosymptoms3SeletedDiv").append("<div id='sym_"+btnId.split('_')[1]+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptoms3DetailDelete_"+btnId.split('_')[1]+"' onclick='removesymptoms3Detail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
        symptoms3counts();
        const element = document.getElementById("symt3"+btnId.split('_')[1]);
        element.remove();
    }

}
function removesymptoms3Detail(btn) {
    let btnId = $(btn).attr('id');
    symbtn = $('#symptoms3_' + btnId.split('_')[1]);
    symbtn.toggleClass('btn-info', false);
    symbtn.toggleClass('btn-default', true);
    $(btn).toggleClass('btn-default', true);
    $(btn).toggleClass('btn-primary', false);
    $(btn).prop({ disabled: true });
    $('#sym_' + btnId.split('_')[1]).remove();
    all_count--;
    symptoms3counts();
    arr_list.splice(btnId.split('_')[1], 1);
    const element = document.getElementById("symt3"+btnId.split('_')[1]);
    element.remove();
}
function symptoms3counts()
{
    document.getElementById("symptoms3CountDiv").innerHTML="<font color='#bb2525'><b>"+symptoms3_counts+"</b></font> symptoms3 selected";
}
</script>

<script>



var symptoms4_counts=0;
$(document).ready(function(){
    $("#pos_symptoms4").change(function(){
        $('#symptoms4sel').hide();
        var yy=$("#pos_symptoms4").val();
        if($("#pos_symptoms4").val()!='')
        {
            symptoms4_counts++;
            all_count++;
            tmm=all_count.toString();
            arr_list.push(tmm);
            $("#symptoms4Div").append("<div class='btn-group' style='margin: 2px;'><input type='button' onclick='togglesymptoms4Button(this)' tabindex='10' class='btn select-btn popButton btn-info' id='symptoms4_"+all_count+"' value='"+yy+"' name='symptoms4'><button type='button' onclick='removesymptoms4Detail(this)' id='symptoms4Delete_"+all_count+"' tabindex='10' class='btn select-btn  btn-primary'><i class='fa fa-close'>&#10005;</i></button></div>");
            $("#nosymptoms4SeletedDiv").append("<div id='sym_"+all_count+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptoms4DetailDelete_"+all_count+"' onclick='removesymptoms4Detail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
            $("#all_fields").append("<div id='symt4"+tmm+"'><input type='hidden' name='advices[]' value='"+yy+"'></div>");
            symptoms4counts();
        }
    });
});

function togglesymptoms4Button(btn) {
    
    $(btn).toggleClass('btn-info', true);
    $(btn).toggleClass('btn-default', false);
    let btnId = $(btn).attr('id');
    qq=arr_list.includes(btnId.split('_')[1]);
    if(qq==false)
    {
        arr_list.push(btnId.split('_')[1]);
        
        console.log(arr_list);
        symDeletebtn = $('#symptoms4Delete_' + btnId.split('_')[1]);
        symDeletebtn.toggleClass('btn-primary', true);
        symDeletebtn.toggleClass('btn-default', false);
        symDeletebtn.prop({ disabled: false });
        var vvv1=$("#symptoms4_"+btnId.split('_')[1]).val();
        $("#nosymptoms4SeletedDiv").append("<div id='sym_"+btnId.split('_')[1]+"' class='box box-info box-solid collapsed-box'><a data-widget='collapse' class='box-header with-border'><i class='fa fa-plus'></i>"+yy+"<i id='symptoms4DetailDelete_"+btnId.split('_')[1]+"' onclick='removesymptoms4Detail(this)' class='fa fa-times fa-1x pull-right'></i></a>  </div>");
        symptoms4counts();
        const element = document.getElementById("symt4"+btnId.split('_')[1]);
        element.remove();
    }

}
function removesymptoms4Detail(btn) {
    let btnId = $(btn).attr('id');
    symbtn = $('#symptoms4_' + btnId.split('_')[1]);
    symbtn.toggleClass('btn-info', false);
    symbtn.toggleClass('btn-default', true);
    $(btn).toggleClass('btn-default', true);
    $(btn).toggleClass('btn-primary', false);
    $(btn).prop({ disabled: true });
    $('#sym_' + btnId.split('_')[1]).remove();
    all_count--;
    symptoms4counts();
    arr_list.splice(btnId.split('_')[1], 1);
    const element = document.getElementById("symt4"+btnId.split('_')[1]);
    element.remove();
}
function symptoms4counts()
{
    document.getElementById("symptoms4CountDiv").innerHTML="<font color='#bb2525'><b>"+symptoms4_counts+"</b></font> symptoms4 selected";
}
</script>
<script>
var coo=2;
function addmed()
{
    $("#"+coo).show();
    coo++;
}

</script>

<script>
 
document.getElementById("myForm").addEventListener("submit", function (event) {
    event.preventDefault(); // Prevent the default form submission
    $(':button[type="submit"]').prop('disabled', true);
	var formData = new FormData(this);
    fetch(event.target.action, {
        method: event.target.method,
        body: formData
    })
    //.then(response => response) // Assuming the response is in JSON format
    .then(response => response.json())
    .then(data => {
        // Handle the response data
        console.log(data);
    //   	alert(data);
      	if(data.error==true)
        {
          	document.getElementById("succ").innerHTML="";
          	document.getElementById("error").innerHTML=data.message;
          	$("#error").show();
          	$("#succ").hide();
        }
      	else
        {
          	document.getElementById("error").innerHTML="";
          	document.getElementById("succ").innerHTML=data.message;
          	//location.reload();
          	$("#succ").show();
          	$("#error").hide();
        }
        $("html, body").animate({ scrollTop: 0 }, "smooth");
        $(':button[type="submit"]').prop('disabled', false);
    })
    .catch(error => {
        // Handle errors
        console.error('Error:', error);
    });
});   
</script>