<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Prescription extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('prescription_model');
        $this->load->model('medicine/medicine_model');
        $this->load->model('patient/patient_model');
        $this->load->model('doctor/doctor_model');
        $this->load->model('hospital/hospital_model');
        if (!$this->ion_auth->in_group(array('admin', 'Pharmacist', 'Doctor', 'Patient', 'Nurse'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        if ($this->ion_auth->in_group(array('Patient'))) {
            redirect('home/permission');
        }

        $data['patients'] = $this->patient_model->getPatient();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['doctors'] = $this->doctor_model->getDoctor();
        if ($this->ion_auth->in_group(array('Doctor'))) {
            $current_user = $this->ion_auth->get_user_id();
            $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        }
        $data['prescriptions'] = $this->prescription_model->getPrescriptionByDoctorId($doctor_id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('prescription', $data);
        $this->load->view('home/footer'); 
    }

    function all() {

        if (!$this->ion_auth->in_group(array('admin', 'Doctor', 'Pharmacist'))) {
            redirect('home/permission');
        }

        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['prescriptions'] = $this->prescription_model->getPrescription();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('all_prescription', $data);
        $this->load->view('home/footer'); 
    }
    
    public function getcustom_prescription_fileds()
    {
        // Search term
        $searchTerm = $this->input->post('searchTerm');
        $type = $this->input->post('type');

        // Get users
        $response = $this->prescription_model->getcustom_prescription_fileds($searchTerm, $type);

        echo json_encode($response);
    }
    
    public function get_medi()
    {
        // Search term
        $searchTerm = $this->input->post('searchTerm');
        $type = $this->input->post('type');

        // Get users
        $response = $this->prescription_model->get_medi($searchTerm, $type);

        echo json_encode($response);
    }
    
    function professional() {

        if (!$this->ion_auth->in_group(array('admin', 'Doctor', 'Pharmacist'))) {
            redirect('home/permission');
        }

        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['prescriptions'] = $this->prescription_model->getPrescription();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('professional', $data);
        $this->load->view('home/footer'); 
    }
    
    function setting() {

        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        //print_r($_POST); exit;

        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        
        $data['prescriptions'] = $this->prescription_model->getPrescription();
        $data['settings'] = $this->settings_model->getSettings();
        $current_user = $this->ion_auth->get_user_id();
        $data['doctor_id'] = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $data['doctor_detial']= $this->doctor_model->getDoctorById($data['doctor_id']);
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $query = $this->db->get('prescription_setting');
        $data['pres_setting']= $query->result();
        
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $query = $this->db->get('quick_medicines');
        $data['quick_medicines']= $query->result();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('setting', $data);
        $this->load->view('home/footer'); 
    }
    
    function write_prescription() {

        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        

        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        
        $data['prescriptions'] = $this->prescription_model->getPrescription();
        $data['settings'] = $this->settings_model->getSettings();
        $current_user = $this->ion_auth->get_user_id();
        $data['doctor_id'] = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $data['doctor_detial']= $this->doctor_model->getDoctorById($data['doctor_id']);
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $query = $this->db->get('prescription_setting');
        $data['pres_setting']= $query->result();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('add', $data);
        $this->load->view('home/footer'); 
    }

    public function addPrescriptionView() {
        
        if (!$this->ion_auth->in_group(array('admin', 'Doctor'))) {
            redirect('home/permission');
        }

        $data = array();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();

        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('add_new_prescription_view', $data);
        $this->load->view('home/footer'); 
    }
    
    public function update_vital_settings() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $height = $this->input->post('height');
        $weight = $this->input->post('weight');
        $BMI = $this->input->post('BMI');
        $temp = $this->input->post('temp');
        $pulse = $this->input->post('pulse');
        $BP = $this->input->post('BP');
        $RR = $this->input->post('RR');
        $SPO2 = $this->input->post('SPO2');
        $Urine_Output = $this->input->post('Urine_Output');
        $Pain = $this->input->post('Pain');
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $query = $this->db->get('prescription_setting');
        $ress= $query->result();
        
        $data1 = array(
            'hospital_id' => $this->session->userdata('hospital_id'),
            'doctor_id' => $doctor_id,
            'height' => $height,
            'weight' => $weight,
            'temperature' => $temp,
            'bmi' => $BMI,
            'pulse' => $pulse,
            'bp' => $BP,
            'SpO2' => $SPO2,
            'Respiratory_Rate' => $RR,
            'Urine_Output' => $Urine_Output,
            'Pain' => $Pain,
            );
        
        if (empty($ress)) {
            
            $this->db->insert('prescription_setting', $data1);
            
        } else {
        
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('doctor_id', $doctor_id);
            $this->db->update('prescription_setting', $data1);
            $var['error'] = false;
            $var['message'] = "Updated Successfully";
            $var['data'] = array();
            print_r(json_encode($var));
          	return;
        }
    }
    
    public function update_visible_settings() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $show_diagnosis = $this->input->post('showDiagnosis');
        $print_diagnosis = $this->input->post('printDiagnosisDetails');
        $showSymptoms = $this->input->post('showSymptoms');
        $printSymptomsDetails = $this->input->post('printSymptomsDetails');
        $showTests = $this->input->post('showTests');
        $printTestsDetails = $this->input->post('printTestsDetails');
        $showAdvise = $this->input->post('showAdvise');
        $printAdviseDetails = $this->input->post('printAdviseDetails');
        $showVital = $this->input->post('showVital');
        $showInvest = $this->input->post('showInvest');
        $showClinicDtl = $this->input->post('showClinicDtl');
        $showDoctorName = $this->input->post('showDoctorName');
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $query = $this->db->get('prescription_setting');
        $ress= $query->result();
        
        $data1 = array(
            'hospital_id' => $this->session->userdata('hospital_id'),
            'doctor_id' => $doctor_id,
            'show_diagnosis' => $show_diagnosis,
            'print_diagnosis' => $print_diagnosis,
            'show_symptoms' => $showSymptoms,
            'print_symptoms' => $printSymptomsDetails,
            'show_test' => $showTests,
            'print_test' => $printTestsDetails,
            'show_advice' => $printAdviseDetails,
            'print_advice' => $printAdviseDetails,
            'print_vitals' => $showVital,
            'print_investigation' => $showInvest,
            'show_clinic_detail' => $showClinicDtl,
            'show_doctor_name' => $showDoctorName,
            );
        
        if (empty($ress)) {
            
            $this->db->insert('prescription_setting', $data1);
            
        } else {
        
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('doctor_id', $doctor_id);
            $this->db->update('prescription_setting', $data1);
            
        }
        $this->session->set_flashdata('feedback', "Updated Successfully");
        redirect('prescription/setting');
    }
    
    public function add_quick_medicine() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $medicineReferenceName = $this->input->post('medicineReferenceName');
        $medicineName = $this->input->post('medicineName');
        $composition = $this->input->post('composition');
        $days = $this->input->post('days');
        $preference = $this->input->post('preference');
        $dosage = $this->input->post('dosage');
        $frequency = $this->input->post('frequency');
        $comments = $this->input->post('comments');
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $data1 = array(
            'medicineReferenceName' => $medicineReferenceName,
            'hospital_id' => $this->session->userdata('hospital_id'),
            'doctor_id' => $doctor_id,
            'medicineName' => $medicineName,
            'composition' => $composition,
            'days' => $days,
            'preference' => $preference,
            'dosage' => $dosage,
            'frequency' => $frequency,
            'comments' => $comments,
            'created_at' => date('Y-m-d H:i:s'),
            );
        
        
            
            $this->db->insert('quick_medicines', $data1);
        $this->session->set_flashdata('feedback', "Added Successfully");
        redirect('prescription/setting');
    }
    
    public function update_templete_settings() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $tid = $this->input->post('prescription_tamplete_id');
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $query = $this->db->get('prescription_setting');
        $ress= $query->result();
        
        $data1 = array(
            'prescription_tamplete_id' => $tid,
            
            );
        
        
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('id', $doctor_id);
        $this->db->update('doctor', $data1);
            
            $signature='';
		    if(!empty($_FILES['signature']['name']))
		    { 
		        $this->load->helper(array('form', 'url'));

                 // Set preference 
                 $config['upload_path'] = './uploads/tmaplete_img/'; 
                 $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                 $config['max_size'] = '20480000'; // max_size in kb 
                 $config['file_name'] = $_FILES['signature']['name']; 
                 $signature=$config['file_name'];
                 // Load upload library 
                 $this->load->library('upload',$config); 
                 $this->upload->initialize($config);
                
                 // File upload
                 if($this->upload->do_upload('signature')){ 
                    // Get data about the file
                    $uploadData = $this->upload->data(); 
                    
                    $signature = $uploadData['file_name']; 
                    //$data['response'] = 'successfully uploaded '.$filename; 
                 }
                 else
                 {
                    $this->session->set_flashdata('feedback', $this->upload->display_errors('<p>', '</p>'));
                    redirect('prescription/setting');
                 }
                
            }
            //print_r($signature); exit;
        if($signature!='')
        {
            $data1 = array(
            'doctor_sign' => 'uploads/tmaplete_img/'.$signature,
            
            );
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('id', $doctor_id);
            $this->db->update('doctor', $data1);
        }
        
        $this->session->set_flashdata('feedback', "Updated Successfully");
        redirect('prescription/setting');
    }
    
    public function add_fields() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $add_field = $this->input->post('add_field');
        $type_id = $this->input->post('type_id');
        $type_name = $this->input->post('type_name');
        
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        
        
        $data1 = array(
            'hospital_id' => $this->session->userdata('hospital_id'),
            'doctor_id' => $doctor_id,
            'type_id' => $type_id,
            'type_name' => $type_name,
            'name' => $add_field,
            'created_at' => date('Y-m-d H:i:s'),
            );
        //print_r($data1); exit;
        $this->db->insert('prescription_layout', $data1);
        $this->session->set_flashdata('feedback', "Added Successfully");
        redirect('prescription/setting');
            
    }
    
    public function delete_field() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $field_id = $this->input->get('field_id');
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        
        $this->db->where('id', $field_id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $this->db->delete('prescription_layout');
        
        $this->session->set_flashdata('feedback', "Deleted Successfully");
        redirect('prescription/setting');
            
    }
    
    public function delete_quick_medicine() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        
        $field_id = $this->input->get('field_id');
        
        $current_user = $this->ion_auth->get_user_id();
        $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        
        $this->db->where('id', $field_id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor_id', $doctor_id);
        $this->db->delete('quick_medicines');
        
        $this->session->set_flashdata('feedback', "Deleted Successfully");
        redirect('prescription/setting');
            
    }

    public function addNewPrescription() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }

        $id = $this->input->post('id');
        $patient = $this->input->post('patient');
        $symptom = $this->input->post('symptoms');
        $medicine = $this->input->post('medicine');
        $dosage = $this->input->post('dosage');
        $frequency = $this->input->post('frequency');
        $days = $this->input->post('days');
        $instruction = $this->input->post('instruction');
        $comments = $this->input->post('comments');
        $note = $this->input->post('history');
        $advice = $this->input->post('advice');
        $diagnosis= $this->input->post('diagnosis');
        $tests= $this->input->post('tests');

        $report = array();

        if (!empty($medicine)) {
            foreach ($medicine as $key => $value) {
                $report[$value] = array(
                    'dosage' => $dosage[$key],
                    'frequency' => $frequency[$key],
                    'days' => $days[$key],
                    'instruction' => $instruction[$key],
                    'comments' => $comments[$key],
                );

                // }
            }

            foreach ($report as $key1 => $value1) {
                $final[] = $key1 . '***' . implode('***', $value1);
            }

            $final_report = implode('###', $final);
        } else {
            $final_report = '';
        }

        
 //print_r($patient);
        //exit;


        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('next_visit', 'Next visit date', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('history', 'Past History', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('symptom', 'History', 'trim|min_length[1]|max_length[1000]|xss_clean');
        // Validating Do And Dont Name Field
        $this->form_validation->set_rules('note', 'Note', 'trim|min_length[1]|max_length[1000]|xss_clean');

        // Validating Advice Field
        $this->form_validation->set_rules('advice', 'Advice', 'trim|min_length[1]|max_length[1000]|xss_clean');

        // Validating Validity Field
        $this->form_validation->set_rules('validity', 'Validity', 'trim|min_length[1]|max_length[100]|xss_clean');
        
        if ($patient == 'add_new') {
            $this->form_validation->set_rules('p_name', 'Patient Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('p_phone', 'Patient Mobile Number', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('email', 'Patient Email', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            
        }

        
        if ($this->form_validation->run() == FALSE) {
            $var['error'] = true;
            $var['message'] = validation_errors();
            $var['data'] = array();
            print_r(json_encode($var));
          	return;
        } else {
            $current_user = $this->ion_auth->get_user_id();
            $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
            $data1 = array();
            
            
            if ($patient == 'add_new') {
                
                $patient_image='';
    		    if(!empty($_FILES['patient_image']['name']))
    		    { 
    		        $this->load->helper(array('form', 'url'));

                     // Set preference 
                     $config['upload_path'] = './uploads/patient_images/'; 
                     $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                     $config['max_size'] = '20480000'; // max_size in kb 
                     $config['file_name'] = $_FILES['patient_image']['name']; 
                     $patient_image=$config['file_name'];
                     // Load upload library 
                     $this->load->library('upload',$config); 
                     $this->upload->initialize($config);
                    
                     // File upload
                     if($this->upload->do_upload('patient_image')){ 
                        // Get data about the file
                        $uploadData = $this->upload->data(); 
                        
                        $filename = $uploadData['file_name']; 
                        //$data['response'] = 'successfully uploaded '.$filename; 
                     }
                     else
                     {
                         
                         echo $this->upload->display_errors('<p>', '</p>');
                         
                     }
                
                }
                $patient_id = rand(10000, 1000000);
                $add_date = date('m/d/y');
                $registration_time = time();
                $patient_add_date = $add_date;
                $data_p = array(
                    'img_url' => $patient_image,
                    'patient_id' => $patient_id,
                    'doctor' => $this->input->post('doctor'),
                    'bloodgroup' => $this->input->post('bloodgroup'),
                    'address' => $this->input->post('address'),
                    'city' => $this->input->post('city'),
                    'state' => $this->input->post('state'),
                    'id_proof_type' => $this->input->post('id_proof_type'),
                    'id_proof' => $this->input->post('id_proof'),
                    'name' => $this->input->post('p_name'),
                    'phone' => $this->input->post('p_phone'),
                    'sex' => $this->input->post('p_gender'),
                    'age' => $this->input->post('p_age'),
                    'add_date' => $patient_add_date,
                    'registration_time' => $registration_time,
                    'how_added' => 'from_appointment',
                    'payment_confirmation' => 'Active',
                    'appointment_confirmation' => 'Active',
                    'appointment_creation' => 'Active',
                    'meeting_schedule' => 'Active'
                );
                //print_r($patient_image);
                //die();
                $username = $this->input->post('p_name');
                // Adding New Patient
                if ($this->ion_auth->email_check($p_email)) {
                    $var['error'] = true;
                    $var['message'] = 'This email address is already registered';
                    $var['data'] = array();
                    print_r(json_encode($var));
                  	return;
                } else {
                    $dfg = 5;
                    $this->ion_auth->register($username, $password, $p_email, $dfg);
                    $ion_user_id = $this->db->get_where('users', array('email' => $p_email))->row()->id;
                    $this->patient_model->insertPatient($data_p);
                    $patient_user_id = $this->db->get_where('patient', array('email' => $p_email))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->patient_model->updatePatient($patient_user_id, $id_info);
                    $this->hospital_model->addHospitalIdToIonUser($ion_user_id, $this->hospital_id);
                }

                $patient = $patient_user_id;
                //    }
            }
            $patientname = $this->patient_model->getPatientById($patient);
            if(empty($patientname))
            {
                $var['error'] = true;
                $var['message'] = 'Invalid Patient ID';
                $var['data'] = array();
                print_r(json_encode($var));
              	return;
            }
            
            if(!empty($symptom)) { $symptom1=implode(",",$symptom); } else{ $symptom1=''; }
            if(!empty($diagnosis)) { $diagnosis1=implode(",",$diagnosis); } else{ $diagnosis1=''; }
            if(!empty($advice)) { $advice1=implode(",",$advice); } else{ $advice1=''; }
            if(!empty($tests)) { $tests1=implode(",",$tests); } else{ $tests1=''; }
            
            $data1 = array(
                'date' => time(),
                'patient' => $patient,
                'doctor' => $doctor_id,
                'symptom' => $symptom1,
                'medicine' => $final_report,
                'note' => $note,
                'diagnosis' => $diagnosis1,
                'advice' => $advice1,
                'test' => $tests1,
                'next_visit_date' => $this->input->post('next_visit'),
            );
            
            if (empty($id)) {
                $l_id=$this->prescription_model->insertPrescription($data1);
                $dataq = array(
                    'prescription_id' => $l_id,
                    'hospital_id' => $this->session->userdata('hospital_id'),
                    'doctor_id' => $doctor_id,
                    'patient_id' => $patient,
                    'created_at' => date('Y-m-d H:i:s'),
                );
                if(!empty($symptom)) {
                    for($i=0;$i<count($symptom);$i++)
                    {
                        $data3 = array('type_id' => 1, 'name' => $symptom[$i], 'type_name' => 'Symptoms');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                if(!empty($diagnosis)) {
                    for($i=0;$i<count($diagnosis);$i++)
                    {
                        $data3 = array('type_id' => 3, 'name' => $diagnosis[$i], 'type_name' => 'Diagnosis');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                if(!empty($advice)) {
                    for($i=0;$i<count($advice);$i++)
                    {
                        $data3 = array('type_id' => 5, 'name' => $advice[$i], 'type_name' => 'Advice');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                if(!empty($tests)) {
                    for($i=0;$i<count($tests);$i++)
                    {
                        $data3 = array('type_id' => 3, 'name' => $tests[$i], 'type_name' => 'tests');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                
            } else {
                $this->prescription_model->updatePrescription($id, $data1);
                
            }
            $var['error'] = false;
            $var['message'] = 'Added Successfully';
            $var['data'] = array();
            print_r(json_encode($var));
          	return;
        }
    }
    
    public function addNewPresc() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }

        $id = $this->input->post('pres_id');
        $patient = $this->input->post('patient');
        $symptom = $this->input->post('symptoms');
        $medicine = $this->input->post('medicine');
        $dosage = $this->input->post('dosage');
        $frequency = $this->input->post('frequency');
        $days = $this->input->post('days');
        $instruction = $this->input->post('instruction');
        $comments = $this->input->post('comments');
        $advice = $this->input->post('advice');
        $diagnosis= $this->input->post('diagnosis');
        $tests= $this->input->post('tests');

        

        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('next_visit', 'Next visit date', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        //$this->form_validation->set_rules('history', 'Past History', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('symptom', 'symptom', 'trim|min_length[1]|max_length[1000]|xss_clean');
        // Validating Do And Dont Name Field
        $this->form_validation->set_rules('note', 'Note', 'trim|min_length[1]|max_length[1000]|xss_clean');

        // Validating Advice Field
        $this->form_validation->set_rules('advice', 'Advice', 'trim|min_length[1]|max_length[1000]|xss_clean');

        // Validating Validity Field
        $this->form_validation->set_rules('validity', 'Validity', 'trim|min_length[1]|max_length[100]|xss_clean');
        
        if ($patient == 'add_new') {
            $this->form_validation->set_rules('p_name', 'Patient Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('p_phone', 'Patient Mobile Number', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('email', 'Patient Email', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            
        }

        
        if ($this->form_validation->run() == FALSE) {
            $var['error'] = true;
            $var['message'] = validation_errors();
            $var['data'] = array();
            print_r(json_encode($var));
          	return;
        } else {
            $current_user = $this->ion_auth->get_user_id();
            $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
            $data1 = array();
            
            $report = array();

        if (!empty($medicine)) {
            foreach ($medicine as $key => $value) {
                $report[$value] = array(
                    'dosage' => $dosage[$key],
                    'frequency' => $frequency[$key],
                    'days' => $days[$key],
                    'instruction' => $instruction[$key],
                    'comments' => $comments[$key],
                );

                // }
            }

            foreach ($report as $key1 => $value1) {
                $final[] = $key1 . '***' . implode('***', $value1);
            }

            $final_report = implode('###', $final);
        } else {
            $final_report = '';
            $var['error'] = true;
            $var['message'] = 'Please Add Atleast One Medicine';
            $var['data'] = array();
            print_r(json_encode($var));
          	return;
        }

            
            if ($patient == 'add_new') {
                
                $patient_image='';
    		    if(!empty($_FILES['patient_image']['name']))
    		    { 
    		        $this->load->helper(array('form', 'url'));

                     // Set preference 
                     $config['upload_path'] = './uploads/patient_images/'; 
                     $config['allowed_types'] = 'jpg|jpeg|png|gif'; 
                     $config['max_size'] = '20480000'; // max_size in kb 
                     $config['file_name'] = $_FILES['patient_image']['name']; 
                     $patient_image=$config['file_name'];
                     // Load upload library 
                     $this->load->library('upload',$config); 
                     $this->upload->initialize($config);
                    
                     // File upload
                     if($this->upload->do_upload('patient_image')){ 
                        // Get data about the file
                        $uploadData = $this->upload->data(); 
                        
                        $filename = $uploadData['file_name']; 
                        //$data['response'] = 'successfully uploaded '.$filename; 
                     }
                     else
                     {
                         
                         echo $this->upload->display_errors('<p>', '</p>');
                         
                     }
                
                }
                $patient_id = rand(10000, 1000000);
                $add_date = date('m/d/y');
                $registration_time = time();
                $patient_add_date = $add_date;
                $data_p = array(
                    'img_url' => $patient_image,
                    'patient_id' => $patient_id,
                    'doctor' => $this->input->post('doctor'),
                    'bloodgroup' => $this->input->post('bloodgroup'),
                    'address' => $this->input->post('address'),
                    'city' => $this->input->post('city'),
                    'state' => $this->input->post('state'),
                    'id_proof_type' => $this->input->post('id_proof_type'),
                    'id_proof' => $this->input->post('id_proof'),
                    'name' => $this->input->post('p_name'),
                    'phone' => $this->input->post('p_phone'),
                    'sex' => $this->input->post('p_gender'),
                    'age' => $this->input->post('p_age'),
                    'add_date' => $patient_add_date,
                    'registration_time' => $registration_time,
                    'how_added' => 'from_appointment',
                    'payment_confirmation' => 'Active',
                    'appointment_confirmation' => 'Active',
                    'appointment_creation' => 'Active',
                    'meeting_schedule' => 'Active'
                );
                //print_r($patient_image);
                //die();
                $username = $this->input->post('p_name');
                // Adding New Patient
                if ($this->ion_auth->email_check($p_email)) {
                    $var['error'] = true;
                    $var['message'] = 'This email address is already registered';
                    $var['data'] = array();
                    print_r(json_encode($var));
                  	return;
                } else {
                    $dfg = 5;
                    $this->ion_auth->register($username, $password, $p_email, $dfg);
                    $ion_user_id = $this->db->get_where('users', array('email' => $p_email))->row()->id;
                    $this->patient_model->insertPatient($data_p);
                    $patient_user_id = $this->db->get_where('patient', array('email' => $p_email))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->patient_model->updatePatient($patient_user_id, $id_info);
                    $this->hospital_model->addHospitalIdToIonUser($ion_user_id, $this->hospital_id);
                }

                $patient = $patient_user_id;
                //    }
            }
            $patientname = $this->patient_model->getPatientById($patient);
            if(empty($patientname))
            {
                $var['error'] = true;
                $var['message'] = 'Invalid Patient ID';
                $var['data'] = array();
                print_r(json_encode($var));
              	return;
            }
            
            if(!empty($symptom)) { $symptom1=implode(",",$symptom); } else{ $symptom1=''; }
            if(!empty($diagnosis)) { $diagnosis1=implode(",",$diagnosis); } else{ $diagnosis1=''; }
            if(!empty($advice)) { $advice1=implode(",",$advice); } else{ $advice1=''; }
            if(!empty($tests)) { $tests1=implode(",",$tests); } else{ $tests1=''; }
            
            $data1 = array(
                'date' => time(),
                'patient' => $patient,
                'doctor' => $doctor_id,
                'symptom' => $symptom1,
                'medicine' => $final_report,
                'diagnosis' => $diagnosis1,
                'advice' => $advice1,
                'test' => $tests1,
                'next_visit_date' => $this->input->post('next_visit'),
                'height' => $this->input->post('height'),
                'weight' => $this->input->post('weight'),
                'bmi' => $this->input->post('bmi'),
                'temperature' => $this->input->post('temp'),
                'pulse' => $this->input->post('pr'),
                'rr' => $this->input->post('rr'),
                'bp' => $this->input->post('bp'),
                'SpO2' => $this->input->post('SpO2'),
            );
            
            if (empty($id)) {
                $l_id=$this->prescription_model->insertPrescription($data1);
                $dataq = array(
                    'prescription_id' => $l_id,
                    'hospital_id' => $this->session->userdata('hospital_id'),
                    'doctor_id' => $doctor_id,
                    'patient_id' => $patient,
                    'created_at' => date('Y-m-d H:i:s'),
                );
                if(!empty($symptom)) {
                    for($i=0;$i<count($symptom);$i++)
                    {
                        $data3 = array('type_id' => 1, 'name' => $symptom[$i], 'type_name' => 'Symptoms');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                if(!empty($diagnosis)) {
                    for($i=0;$i<count($diagnosis);$i++)
                    {
                        $data3 = array('type_id' => 3, 'name' => $diagnosis[$i], 'type_name' => 'Diagnosis');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                if(!empty($advice)) {
                    for($i=0;$i<count($advice);$i++)
                    {
                        $data3 = array('type_id' => 5, 'name' => $advice[$i], 'type_name' => 'Advice');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                if(!empty($tests)) {
                    for($i=0;$i<count($tests);$i++)
                    {
                        $data3 = array('type_id' => 3, 'name' => $tests[$i], 'type_name' => 'tests');
                        $dataq2 = array_merge($data3, $dataq);
                        $this->db->insert('prescription_stting_list', $dataq2);
                    }
                }
                
            } else {
                $this->prescription_model->updatePrescription($id, $data1);
                $var['error'] = false;
                $var['message'] = 'Updated Successfully';
                $var['data'] = array();
                print_r(json_encode($var));
              	return;
            }
            $var['error'] = false;
            $var['message'] = 'Added Successfully';
            $var['data'] = array();
            print_r(json_encode($var));
          	return;
        }
    }

    function viewPrescription() {
        $id = $this->input->get('id');
        $data['prescription'] = $this->prescription_model->getPrescriptionById($id);

        if (!empty($data['prescription']->hospital_id)) {
            if ($data['prescription']->hospital_id != $this->session->userdata('hospital_id')) {
                $this->load->view('home/permission');
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); 
                $this->load->view('prescription_view_1', $data);
                $this->load->view('home/footer'); 
            }
        } else {
            $this->load->view('home/permission');
        }
    }

    function viewPrescriptionPrint() {
        $id = $this->input->get('id');
        $data['prescription'] = $this->prescription_model->getPrescriptionById($id);

        if (!empty($data['prescription']->hospital_id)) {
            if ($data['prescription']->hospital_id != $this->session->userdata('hospital_id')) {
                $this->load->view('home/permission');
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); 
                $this->load->view('prescription_view_print', $data);
                $this->load->view('home/footer'); 
            }
        } else {
            $this->load->view('home/permission');
        }
    }

    function editPrescription() {
        $data = array();
        $id = $this->input->get('id');
        // $data['patients'] = $this->patient_model->getPatient();
        // $data['doctors'] = $this->doctor_model->getDoctor();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['prescription'] = $this->prescription_model->getPrescriptionById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['patients'] = $this->patient_model->getPatientById($data['prescription']->patient);
        $data['doctors'] = $this->doctor_model->getDoctorById($data['prescription']->doctor);
        if (!empty($data['prescription']->hospital_id)) {
            if ($data['prescription']->hospital_id != $this->session->userdata('hospital_id')) {
                $this->load->view('home/permission');
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); 
                $this->load->view('add_new_prescription_view', $data);
                $this->load->view('home/footer'); // just the footer file 
            }
        } else {
            $this->load->view('home/permission');
        }
    }

    function editPrescriptionByJason() {
        $id = $this->input->get('id');
        $data['prescription'] = $this->prescription_model->getPrescriptionById($id);
        echo json_encode($data);
    }

    function getPrescriptionByPatientIdByJason() {
        $id = $this->input->get('id');
        $prescriptions = $this->prescription_model->getPrescriptionByPatientId($id);
        foreach ($prescriptions as $prescription) {
            $lists[] = ' <div class="pull-left prescription_box" style = "padding: 10px; background: #fff;"><div class="prescription_box_title">Prescription Date</div> <div>' . date('d-m-Y', $prescription->date) . '</div> <div class="prescription_box_title">Medicine</div> <div>' . $prescription->medicine . '</div> </div> ';
        }
        $data['prescription'] = $lists;
        $lists = NULL;
        echo json_encode($data);
    }

    function delete() {
        $id = $this->input->get('id');
        $admin = $this->input->get('admin');
        $patient = $this->input->get('patient');
        $data['prescription'] = $this->prescription_model->getPrescriptionById($id);
        if (!empty($data['prescription']->hospital_id)) {
            if ($data['prescription']->hospital_id != $this->session->userdata('hospital_id')) {
                $this->load->view('home/permission');
            } else {
                $this->prescription_model->deletePrescription($id);
                $this->session->set_flashdata('feedback', lang('deleted'));
                if (!empty($patient)) {
                    redirect('patient/caseHistory?patient_id=' . $patient);
                } elseif (!empty($admin)) {
                    redirect('prescription/all');
                } else {
                    redirect('prescription');
                }
            }
        } else {
            $this->load->view('home/permission');
        }
    }

    public function prescriptionCategory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['categories'] = $this->prescription_model->getPrescriptionCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('prescription_category', $data);
        $this->load->view('home/footer'); 
    }

    public function addCategoryView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('add_new_category_view');
        $this->load->view('home/footer'); 
    }
    
    public function wrirte_prescription() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        $current_user = $this->ion_auth->get_user_id();
        $data['doctor_id'] = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $doctor_detial= $this->doctor_model->getDoctorById($data['doctor_id']);
        
        $data['settings'] = $this->settings_model->getSettings();
        
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['prescriptions'] = $this->prescription_model->getPrescription();
        $this->load->view('home/dashboard', $data); 
        if($doctor_detial->prescription_tamplete_id==1)
        {
            $this->load->view('add', $data);
        }
        else
        {
            $this->load->view('professional', $data);
        }
            
        $this->load->view('home/footer');
    }
    
    public function edit_prescription() {
        if (!$this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }
        if(isset($_GET['id']))
        {
            $id=$_GET['id'];
        }
        else
        {
            redirect('prescription/all');
        }
        $current_user = $this->ion_auth->get_user_id();
        $data['doctor_id'] = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
        $doctor_detial= $this->doctor_model->getDoctorById($data['doctor_id']);
        
        $data['settings'] = $this->settings_model->getSettings();
        $data['prescription'] = $this->prescription_model->getPrescriptionById($id);
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['med']=explode("###",$data['prescription']->medicine);
        //print_r(explode("***",$med[0])['0']);
        //exit;
        
        $this->load->view('home/dashboard', $data); 
        $this->load->view('add', $data);
        $this->load->view('home/footer');
    }

    public function addNewCategory() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Category Name Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); 
            $this->load->view('add_new_category_view');
            $this->load->view('home/footer'); 
        } else {
            $data = array();
            $data = array('category' => $category,
                'description' => $description
            );
            if (empty($id)) {
                $this->prescription_model->insertPrescriptionCategory($data);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                $this->prescription_model->updatePrescriptionCategory($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('prescription/prescriptionCategory');
        }
    }

    function edit_category() {
        $data = array();
        $id = $this->input->get('id');
        $data['prescription'] = $this->prescription_model->getPrescriptionCategoryById($id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('add_new_category_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editPrescriptionCategoryByJason() {
        $id = $this->input->get('id');
        $data['prescriptioncategory'] = $this->prescription_model->getPrescriptionCategoryById($id);
        echo json_encode($data);
    }

    function deletePrescriptionCategory() {
        $id = $this->input->get('id');
        $this->prescription_model->deletePrescriptionCategory($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('prescription/prescriptionCategory');
    }

    function getPrescriptionListByDoctor() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        
        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];
        
        $doctor_ion_id = $this->ion_auth->get_user_id();
        $doctor = $this->db->get_where('doctor', array('ion_user_id' => $doctor_ion_id))->row()->id;
        if ($limit == -1) {
            if (!empty($search)) {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionBysearchByDoctor($doctor, $search, $order, $dir);
            } else {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionByDoctorWithoutSearch($doctor, $order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionByLimitBySearchByDoctor($doctor, $limit, $start, $search, $order, $dir);
            } else {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionByLimitByDoctor($doctor, $limit, $start, $order, $dir);
            }
        }


        //  $data['patients'] = $this->patient_model->getVisitor();
        $i = 0;
        $option1 = '';
        $option2 = '';
        $option3 = '';
        foreach ($data['prescriptions'] as $prescription) {
            //$i = $i + 1;
            $settings = $this->settings_model->getSettings();

            $option1 = '<a class="btn btn-info btn-xs btn_width" href="prescription/viewPrescription?id=' . $prescription->id . '"><i class="fa fa-eye">' . lang('view') . ' ' . lang('prescription') . ' </i></a>';
            $option3 = '<a class="btn btn-info btn-xs btn_width editPrescription" data-toggle="modal" data-id="' . $prescription->id .  '"><i class="fa fa-edit"></i> ' . lang('edit') . ' ' . lang('prescription') . '</a>';
            $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="prescription/delete?id=' . $prescription->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i></a>';
            $options4 = '<a class="btn btn-info btn-xs invoicebutton" title="' . lang('print') . '" style="color: #fff;" href="prescription/viewPrescriptionPrint?id=' . $prescription->id . '"target="_blank"> <i class="fa fa-print"></i> ' . lang('print') . '</a>';

            if (!empty($prescription->medicine)) {
                $medicine = explode('###', $prescription->medicine);
                $medicinelist = '';
                foreach ($medicine as $key => $value) {
                    $medicine_id = explode('***', $value);
                    $medicine_name_with_dosage = $this->medicine_model->getMedicineById($medicine_id[0])->name . ' -' . $medicine_id[1];
                    $medicine_name_with_dosage = $medicine_name_with_dosage . ' | ' . $medicine_id[3] . '<br>';
                    rtrim($medicine_name_with_dosage, ',');
                    $medicinelist .= '<p>' . $medicine_name_with_dosage . '</p>';
                }
            } else {
                $medicinelist = '';
            }
            $patientdetails = $this->patient_model->getPatientById($prescription->patient);
            if (!empty($patientdetails)) {
                $patientname = $patientdetails->name;
            } else {
                //$patientname = $prescription->patientname;
                $patientname = "";
            }
            $info[] = array(
                date('d-m-Y', $prescription->date),
                $prescription->id,
                $patientname,
                $prescription->patient,
                $medicinelist,
                $option1 . ' ' . $option3 . ' ' . $option2 . ' ' . $options4
            );
            $i = $i + 1;
        }

        if ($data['prescriptions']) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => count($this->prescription_model->getPrescriptionByDoctorId($doctor)),
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }
    
    function getSymptomsByPatientId() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $patient_id=$this->input->get('patient_id');
        $type=$this->input->get('type');
        
        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];
        
        $doctor_ion_id = $this->ion_auth->get_user_id();
        $doctor = $this->db->get_where('doctor', array('ion_user_id' => $doctor_ion_id))->row()->id;
        
                $data['prescriptions'] = $this->prescription_model->getSymptomsByPatientId($doctor, $limit, $start, $order, $dir, $patient_id, $type);
           

        //  $data['patients'] = $this->patient_model->getVisitor();
        $i = 0;
        $option1 = '';
        $option2 = '';
        $option3 = '';
        foreach ($data['prescriptions'] as $prescription) {
            //$i = $i + 1;
            $settings = $this->settings_model->getSettings();

            $option1 = '<a class="btn btn-info btn-xs btn_width" href="prescription/viewPrescription?id=' . $prescription->id . '"><i class="fa fa-eye">' . lang('view') . ' ' . lang('prescription') . ' </i></a>';
            $option3 = '<a class="btn btn-info btn-xs btn_width editPrescription" data-toggle="modal" data-id="' . $prescription->id .  '"><i class="fa fa-edit"></i> ' . lang('edit') . ' ' . lang('prescription') . '</a>';
            $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="prescription/delete?id=' . $prescription->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i></a>';
            $options4 = '<a class="btn btn-info btn-xs invoicebutton" title="' . lang('print') . '" style="color: #fff;" href="prescription/viewPrescriptionPrint?id=' . $prescription->id . '"target="_blank"> <i class="fa fa-print"></i> ' . lang('print') . '</a>';

            $medicinelist = '';
            $patientdetails = $this->patient_model->getPatientById($prescription->patient_id);
            if (!empty($patientdetails)) {
                $patientname = $patientdetails->name;
            } else {
                //$patientname = $prescription->patientname;
                $patientname = "";
            }
            $info[] = array(
                $prescription->created_at,
                $prescription->patient_id,
                $patientname,
                $prescription->prescription_id,
                $prescription->name,
                $option1 . ' ' . $option3 . ' ' . $option2 . ' ' . $options4
            );
            $i = $i + 1;
        }

        if ($data['prescriptions']) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => count($this->prescription_model->getPrescriptionByDoctorId($doctor)),
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getPrescriptionList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        
        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionBysearch($search, $order, $dir);
            } else {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionWithoutSearch($order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['prescriptions'] = $this->prescription_model->getPrescriptionByLimit($limit, $start, $order, $dir);
            }
        }


        //  $data['patients'] = $this->patient_model->getVisitor();
        $i = 0;
        $option1 = '';
        $option2 = '';
        $option3 = '';
        foreach ($data['prescriptions'] as $prescription) {
            //$i = $i + 1;
            $settings = $this->settings_model->getSettings();

            $option1 = '<a title="' . lang('view') . ' ' . lang('prescription') . '" class="btn btn-info btn-xs btn_width" href="prescription/viewPrescription?id=' . $prescription->id . '"><i class="fa fa-eye"> ' . lang('view') . ' ' . lang('prescription') . ' </i></a>';
            // $option3 = '<a class="btn btn-info btn-xs btn_width" href="prescription/editPrescription?id=' . $prescription->id . '" data-id="' . $prescription->id . '"><i class="fa fa-edit"></i> ' . lang('edit') . ' ' . lang('prescription') . '</a>';
            $option3 = '<a href="prescription/edit_prescription?id='. $prescription->id.'" class="btn btn-info btn-xs btn_width editPrescription2" data-id="' . $prescription->id .  '"><i class="fa fa-edit"></i> ' . lang('edit') . ' ' . lang('prescription') . '</a>';
           
            $option2 = '<a class="btn btn-info btn-xs btn_width delete_button" href="prescription/delete?id=' . $prescription->id . '&admin=' . $prescription->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"> </i></a>';
            $options4 = '<a class="btn btn-info btn-xs invoicebutton" title="' . lang('print') . '" style="color: #fff;" href="prescription/viewPrescriptionPrint?id=' . $prescription->id . '"target="_blank"> <i class="fa fa-print"></i> ' . lang('print') . '</a>';

            //if (!empty($prescription->medicine)) {
            if (0) {
                $medicine = explode('###', $prescription->medicine);
                $medicinelist = '';
                foreach ($medicine as $key => $value) {
                    $medicine_id = explode('***', $value);
                    $medicine_name_with_dosage = $this->medicine_model->getMedicineById($medicine_id[0])->name . ' -' . $medicine_id[1];
                    $medicine_name_with_dosage = $medicine_name_with_dosage . ' | ' . $medicine_id[3] . '<br>';
                    rtrim($medicine_name_with_dosage, ',');
                    $medicinelist .= '<p>' . $medicine_name_with_dosage . '</p>';
                }
            } else {
                $medicinelist = '';
                $medicinelist = explode('***', $prescription->medicine)['0'];
            }
            $patientdetails = $this->patient_model->getPatientById($prescription->patient);
            if (!empty($patientdetails)) {
                $patientname = $patientdetails->name;
            } else {
                //$patientname = $prescription->patientname;
                $patientname = "";
            }
            $doctordetails = $this->doctor_model->getDoctorById($prescription->doctor);
            if (!empty($doctordetails)) {
                $doctorname = $doctordetails->name;
            } else {
                $doctorname = $prescription->doctorname;
            }

            if ($this->ion_auth->in_group(array('Pharmacist', 'Receptionist'))) {
                $option2 = '';
                $option3 = '';
            }

            $info[] = array(
                $prescription->id,
                date('d-m-Y h:i A', $prescription->date),
                $doctorname,
                $patientname,
                $medicinelist,
                $option1 . ' ' . $option3 . ' ' . $options4 . ' ' . $option2
            );
            $i = $i + 1;
        }

        if ($data['prescriptions']) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => count($this->prescription_model->getPrescription()),
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
            echo json_encode($output);
            exit;
        }

        echo json_encode($output);
    }
    
    
    // prescription layout
    // add investigation
    
}

/* End of file prescription.php */
/* Location: ./application/modules/prescription/controllers/prescription.php */
